<?xml version="1.0" encoding="UTF-8"?>

<!--
/**
*  XSLT tei2indd
*
*  Copyright (c) 2009-2015
*  Pôle Document Numérique
*  Maison de la Recherche en Sciences Humaines
*  Université de Caen Basse-Normandie
*  Esplanade de la Paix
*  Campus 1
*  14032 Caen Cedex
*
*  This program is free software: you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation, either version 3 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*  <http://www.gnu.org/licenses/>
*
*  See http://www.unicaen.fr/recherche/mrsh/document_numerique/equipe
*      for a list of contributors
*/
-->


<xsl:stylesheet version="2.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:xhtml="http://www.w3.org/TR/xhtml/strict"
    	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
		xmlns:aid="http://ns.adobe.com/AdobeInDesign/4.0/"
		xmlns:aid5="http://ns.adobe.com/AdobeInDesign/5.0/"
		xmlns:tei="http://www.tei-c.org/ns/1.0"
		xmlns="http://www.tei-c.org/ns/1.0"
		xmlns:xi="http://www.w3.org/2001/XInclude"
		exclude-result-prefixes="tei"
>
<xsl:output method="xml" encoding="UTF-8" indent="no"/>

<xsl:param name="figuresMode" select="figuresMode"/>
<xsl:param name="figuresVert" select="figuresVert"/>
<xsl:param name="table" select="table"/>
<xsl:param name="authorLocation" select="authorLocation"/>
<xsl:param name="datesLocation" select="datesLocation"/>
<xsl:param name="withAbstract" select="withAbstract"/>
<xsl:param name="withBiography" select="withBiography"/>
<xsl:param name="biographyPosUE" select="biographyPosUE"/>
<xsl:param name="bio" select="bio"/>
<xsl:param name="biographyPosVOL" select="biographyPosVOL"/>
<xsl:param name="lang" select="lang"/>
<xsl:param name="meta" select="meta"/>
<xsl:param name="appendixLocation" select="appendixLocation"/>
<xsl:param name="endnote" select="endnote"/>
<xsl:param name="titrePartie" select="titrePartie"/>
    
<xsl:variable name="typoRef">
	<style eq="bold">gras</style>
	<style eq="italic">Italique</style>
	<style eq="bold italic">italic_gras</style>
	<style eq="italic bold">italic_gras</style>
	<style eq="small-caps">SC</style>
	<style eq="small-caps-ital">SC_italic</style>
	<style eq="small-caps italic">SC_italic</style>
	<style eq="italic small-caps">SC_italic</style>
	<style eq="strikethrough">line-through</style>
	<style eq="sup">Exposant</style>
	<style eq="sup italic">Exposant_Italic</style>
	<style eq="italic sup">Exposant_Italic</style>
	<style eq="sub">Indice</style>
	<style eq="underline">souligne</style>
</xsl:variable>

<xsl:template match="@*|node()">
  <xsl:copy>
    <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
</xsl:template>

<xsl:template match="tei:titleStmt">
    <titleStmt>
        <xsl:copy-of select="child::*"/>
        <xsl:if test="$titrePartie != ''">
            <title type="part"><xsl:value-of select="$titrePartie"/></title>
        </xsl:if>
    </titleStmt>
</xsl:template>
    
<xsl:template match="tei:text">
  <text>
  	<xsl:comment>figuresVert=<xsl:value-of select="$figuresVert"/></xsl:comment>
  	<xsl:comment>endnote=<xsl:value-of select="$endnote"/></xsl:comment>
	<xsl:comment>authorLocation=<xsl:value-of select="$authorLocation"/></xsl:comment>
	<xsl:comment>appendixLocation=<xsl:value-of select="$appendixLocation"/></xsl:comment>
      <xsl:choose>
          <xsl:when test="$endnote='false'">
              <xsl:comment>$endnote = false => traitement des notes de fin par InDesign</xsl:comment>
              <xsl:apply-templates/>
          </xsl:when>
          <xsl:otherwise>
              <!-- $notesend = true => traitement des notes de fin par Métopes -->
              <xsl:comment>$endnote = true => traitement des notes de fin par Métopes</xsl:comment>
              <xsl:apply-templates/>
              <xsl:for-each select="descendant::tei:note[@place='end']">
                <xsl:call-template name="notesDiv"/>
              </xsl:for-each>
          </xsl:otherwise>
      </xsl:choose>    
  </text>
</xsl:template>

<xsl:template match="tei:body">
	<body>
		<xsl:call-template name="moveFront"/>
		<xsl:apply-templates/>
        <xsl:call-template name="moveBack"/>
	</body>
	<xsl:if test="$authorLocation='end'"><xsl:text>
</xsl:text>
		<xsl:apply-templates select="preceding-sibling::tei:front/tei:titlePage//tei:docAuthor|preceding-sibling::tei:front/tei:titlePage//tei:byline"/>
	</xsl:if>
	<xsl:if test="$datesLocation='datesEnd'"><xsl:text>
</xsl:text><p aid:pstyle="txt_Date_reception">
      <xsl:apply-templates select="//tei:ab[@type='editorial_workflow']/tei:date[@type='received']/node()"/><xsl:text>
</xsl:text>
    </p>
    <p aid:pstyle="txt_Date_acceptation">
      <xsl:apply-templates select="//tei:ab[@type='editorial_workflow']/tei:date[@type='accepted']/node()"/>
    </p>    
	</xsl:if>
</xsl:template>

<xsl:template name="moveFront">
	<front>
		<xsl:apply-templates select="../tei:front/*"/>
	</front>
</xsl:template>
    
<xsl:template name="moveBack">
	<back>
        <xsl:choose>
            <xsl:when test="$appendixLocation='beforeTitle'">
                <!-- afterTitle = Avant la bibliographie -->
                <xsl:apply-templates select="../*:back/*:div[@type='annexe']"/>
                <xsl:apply-templates select="../*:back/*:div[@type='bibliographie']"/>
                <xsl:if test="$withBiography='true' and $bio='true'"><xsl:text>
</xsl:text><div type="biography">
                        <xsl:for-each select="../*:back//*:div[@type='biography']//*:p">
                            <p aid:pstyle="txt_Biographie">
                                <xsl:apply-templates/>
                            </p>
                        </xsl:for-each>
                    </div>
                </xsl:if>
            </xsl:when>
            <xsl:when test="$appendixLocation='NA'">
                <xsl:apply-templates select="../*:back/*:div[@type='bibliographie']"/>
                <xsl:apply-templates select="../*:back/*:div[@type='annexe']"/>
                <xsl:if test="$withBiography='true' and $bio='true'"><xsl:text>
</xsl:text><div type="biography">
                        <xsl:for-each select="../*:back//*:div[@type='biography']//*:p">
                            <p aid:pstyle="txt_Biographie">
                                <xsl:apply-templates/>
                            </p>
                        </xsl:for-each>
                    </div>
                </xsl:if>
            </xsl:when>
            <xsl:when test="$appendixLocation='afterTitle'">
                <!-- afterTitle = Après la bibliographie -->
                <xsl:apply-templates select="../*:back/*:div[@type='bibliographie']"/>
                <xsl:apply-templates select="../*:back/*:div[@type='annexe']"/>
                <xsl:if test="$withBiography='true' and $bio='true'"><xsl:text>
</xsl:text><div type="biography">
                        <xsl:for-each select="../*:back//*:div[@type='biography']//*:p">
                            <p aid:pstyle="txt_Biographie">
                                <xsl:apply-templates/>
                            </p>
                        </xsl:for-each>
                    </div>
                </xsl:if>
            </xsl:when>
            <xsl:when test="not($appendixLocation='beforeTitle' or 'afterTitle')">
                <xsl:apply-templates select="../*:back/*:div[@type='bibliographie']"/>
                <xsl:apply-templates select="../*:back/*:div[@type='annexe']"/>
                <xsl:if test="$withBiography='true' and $bio='true'"><xsl:text>
</xsl:text><div type="biography">
                        <xsl:for-each select="../*:back//*:div[@type='biography']//*:p">
                            <p aid:pstyle="txt_Biographie">
                                <xsl:apply-templates/>
                            </p>
                        </xsl:for-each>
                    </div>
                </xsl:if>
            </xsl:when>
            <xsl:otherwise/>
	   </xsl:choose>
	</back>
</xsl:template>

<xsl:template match="tei:front[ancestor::tei:text[@xml:id='text']]"/>
<xsl:template match="tei:back[ancestor::tei:text[@xml:id='text']]"/>

<xsl:template match="@xml:id">
  <xsl:attribute name="id"><xsl:value-of select="."/></xsl:attribute>
</xsl:template>

<xsl:template match="tei:titlePage">
<xsl:if test="@type='pagedetitre'">
	<titlePage>
		<xsl:attribute name="id"><xsl:value-of select="@xml:id"/></xsl:attribute>
		<xsl:attribute name="type"><xsl:text>pagedetitre</xsl:text></xsl:attribute>
      <titlePart aid:pstyle="Vol_faux_titre" style="Vol_faux_titre">
			   <xsl:apply-templates select="descendant::tei:titlePart[@type='main']|descendant::tei:p[@rend='title-main']|descendant::tei:p[@aid:pstyle='Vol_titre']/node()"/>
      </titlePart><xsl:text>
</xsl:text>
			<xsl:apply-templates/>
			<xsl:call-template name="copyrightPage"/>
	</titlePage>
</xsl:if>
<xsl:if test="not(@type)">
<titlePage>
	<xsl:choose>
        <xsl:when test="$authorLocation='NA'">
			<xsl:apply-templates select="./tei:docTitle"/>
		</xsl:when>
		<xsl:when test="$authorLocation='beforeTitle'">
			<xsl:apply-templates select="./tei:docAuthor|./tei:byline"/>
			<xsl:apply-templates select="./tei:docTitle"/>
		</xsl:when>
		<xsl:when test="$authorLocation='afterTitle'">
			<xsl:apply-templates/>
		</xsl:when>
		<xsl:when test="$authorLocation='end'">
			<xsl:apply-templates select="./tei:docTitle"/>
		</xsl:when>
        <xsl:when test="not($authorLocation='beforeTitle' or 'afterTitle' or 'end')">
			<xsl:apply-templates select="./tei:docTitle"/>
		</xsl:when>
        <xsl:otherwise/>
	</xsl:choose>
  	<xsl:if test="$datesLocation='datesFront'">
			<p aid:pstyle="txt_Date_reception">
      <xsl:apply-templates select="//tei:ab[@type='editorial_workflow']/tei:date[@type='received']/node()"/><xsl:text>
</xsl:text>
    </p>
    <p aid:pstyle="txt_Date_acceptation">
      <xsl:apply-templates select="//tei:ab[@type='editorial_workflow']/tei:date[@type='accepted']/node()"/><xsl:text>
</xsl:text>
    </p>    
	</xsl:if>
</titlePage>
</xsl:if>
</xsl:template>

<xsl:template name="copyrightPage">
	<titlePage type="copyright">
	<xsl:if test="./following-sibling::tei:titlePage[@type='pagedecredits']/tei:byline[@aid:pstyle='Vol_publieur']">
		<xsl:copy-of select="./following-sibling::tei:titlePage[@type='pagedecredits']/tei:byline[@aid:pstyle='Vol_publieur']"/>
	<xsl:text>
</xsl:text>
	</xsl:if>
	<xsl:if test="./following-sibling::tei:titlePage[@type='pagedecredits']/tei:byline[@aid:pstyle='Vol_biblio']">
		<xsl:copy-of select="./following-sibling::tei:titlePage[@type='pagedecredits']/tei:byline[@aid:pstyle='Vol_biblio']"/>
	<xsl:text>
</xsl:text>
	</xsl:if>
	<xsl:if test="./following-sibling::tei:titlePage[@type='pagedecredits']/tei:byline[@aid:pstyle='Vol_droits']">
		<xsl:copy-of select="./following-sibling::tei:titlePage[@type='pagedecredits']/tei:byline[@aid:pstyle='Vol_droits']"/>
	<xsl:text>
</xsl:text>
	</xsl:if>
	<xsl:if test="./following-sibling::tei:titlePage[@type='pagedecredits']/tei:byline[@aid:pstyle='Vol_editeur']">
		<xsl:copy-of select="./following-sibling::tei:titlePage[@type='pagedecredits']/tei:byline[@aid:pstyle='Vol_editeur']"/>
	<xsl:text>
</xsl:text>
	</xsl:if>
	<xsl:if test="./following-sibling::tei:titlePage[@type='pagedecredits']/tei:byline[@aid:pstyle='Vol_partenaire']">
		<xsl:copy-of select="./following-sibling::tei:titlePage[@type='pagedecredits']/tei:byline[@aid:pstyle='Vol_partenaire']"/>
	<xsl:text>
</xsl:text>
	</xsl:if>
	</titlePage>
</xsl:template>

<!-- notes préliminaires : indentation et ajout des styles -->
<xsl:template match="tei:note[@type][parent::tei:front]">
    <xsl:copy>
			<xsl:apply-templates select="./@*"/>
            <xsl:attribute name="aid:pstyle">
                <xsl:value-of select="concat('note_',@type)"/>
            </xsl:attribute>
			<xsl:apply-templates/>
     </xsl:copy><xsl:text>
</xsl:text>
</xsl:template>

<!-- options d'import des résumés et mots-clés -->
<xsl:template match="tei:div[@type='resume_motscles']">
	<xsl:choose>
		<xsl:when test="$withAbstract='true'">
			<xsl:choose>
				<xsl:when test="$lang='true'">
					<div type="resume_motscles">
						<xsl:apply-templates select="tei:p[@aid:pstyle='txt_Resume'][1]"/>
						<xsl:apply-templates select="tei:p[@aid:pstyle='txt_Motclef'][1]"/>
					</div>
				</xsl:when>
				<xsl:when test="$lang='false'">
					<div type="resume_motscles">
						<xsl:apply-templates/>
					</div>
				</xsl:when>
			</xsl:choose>
		</xsl:when>
		<xsl:when test="$withAbstract='false'">
		</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template name="notesDiv">
	<xsl:text>
</xsl:text>
<p aid:pstyle="txt_NotesFin"><hi aid:cstyle="debut_Note"><ref type="link"><xsl:attribute name="target"><xsl:value-of select="concat('#',./@xml:id)"/></xsl:attribute><xsl:value-of select="./@n"/>.&#00009;</ref></hi><anchor type="link" id="ref{./@xml:id}"/>
<xsl:for-each select="child::tei:p"><xsl:apply-templates/><!--xsl:text>
</xsl:text--></xsl:for-each></p>
</xsl:template>

<xsl:template match="*[@aid:pstyle and not(self::table) and not(self::cell) and not(self::*:quote) and not(self::table[@aid:pstyle='titre_Tableau'])]">
<xsl:choose>
  <xsl:when test="local-name()='note' and ./@type='marginalia'">
  	<marginalia type="note_marginale"><xsl:copy-of select="./text()|node()"/></marginalia>
  </xsl:when>
	<xsl:when test="local-name()='note' and ./@place='foot'">
	<xsl:text>
</xsl:text>
		<xsl:copy>
			<xsl:apply-templates select="./@*"/>
			<xsl:apply-templates/>
		</xsl:copy>
	<xsl:text>
</xsl:text>
	</xsl:when>
	<xsl:when test="local-name()='l'">
		<num aid:cstyle="num_vers"><xsl:value-of select="./@n"/></num><xsl:text>&#00009;</xsl:text>
		<xsl:text disable-output-escaping="yes">&lt;l aid:pstyle="</xsl:text><xsl:value-of select="@aid:pstyle"/><xsl:text disable-output-escaping="yes">"&gt;</xsl:text>
              <xsl:apply-templates/>
              <xsl:text disable-output-escaping="yes">&lt;/l&gt;</xsl:text>
	<xsl:text>
</xsl:text>
	</xsl:when>
	<xsl:when test="local-name()='p'">
		<xsl:copy>
			<xsl:choose>
				<xsl:when test="local-name(preceding-sibling::node()[1])='head' and @aid:pstyle='txt_Normal'">
					<xsl:attribute name="aid:pstyle">txt_Normal_sa</xsl:attribute>
				</xsl:when>
				<xsl:when test="local-name(preceding-sibling::node()[not(self::text())][1])='item' and @aid:pstyle='txt_Normal' 
                                or local-name(preceding-sibling::node()[not(self::text())][1])='figure' and @aid:pstyle='txt_Normal' 
                                or local-name(preceding-sibling::node()[not(self::text())][1])='sp' and @aid:pstyle='txt_Normal' 
                                or local-name(preceding-sibling::node()[not(self::text())][1])='ab' and preceding-sibling::node()[1]/@rendition='tableau-donnees' and @aid:pstyle='txt_Normal' 
                                or local-name(preceding-sibling::node()[not(self::text())][1])='p' and preceding-sibling::node()[1]/@aid:pstyle='table-credits-sources' and @aid:pstyle='txt_Normal'
                                or local-name(preceding-sibling::node()[not(self::text())][1])='p' and preceding-sibling::node()[not(self::text())][1]/@aid:pstyle='txt_separateur'
                                or preceding-sibling::*:cit[@type='linguistic'][1] and @aid:pstyle='txt_Normal' ">
					<xsl:attribute name="aid:pstyle">txt_Normal_sa_bis</xsl:attribute>
				</xsl:when>
        <xsl:when test="local-name(preceding-sibling::node()[1])='bibl[not(@sources)]' and @aid:pstyle='txt_Normal'">
					<xsl:attribute name="aid:pstyle">premierPara</xsl:attribute>
				</xsl:when>
                <xsl:when test="local-name(following-sibling::node()[1])='p' and @aid:pstyle='txt_chapo'">
					<xsl:attribute name="aid:pstyle">txt_chapo_premierpara</xsl:attribute>
				</xsl:when>
				<xsl:when test="local-name(preceding-sibling::node()[1])='head' and @aid:pstyle='Txt_Standard'">
					<xsl:attribute name="aid:pstyle">Txt_Standard_sa</xsl:attribute>
				</xsl:when>
       
				<xsl:otherwise>
					<xsl:apply-templates select="./@*"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates/>
		</xsl:copy>
                <xsl:choose>
                  <xsl:when test="local-name(parent::node())='cell'">
                    <xsl:if test="position()!=last()">
                      <xsl:text>
</xsl:text>
                    </xsl:if>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text>
</xsl:text>
                  </xsl:otherwise>
                </xsl:choose>
	</xsl:when>
	<xsl:when test="local-name()='head'">
        <xsl:if test="parent::tei:listBibl[preceding-sibling::tei:listBibl]"><xsl:text>
</xsl:text>
        </xsl:if>
		<xsl:element name="head">
                  <!-- Si le paragraphe suit un encadré on en garde une trace pour restaurer le bon style -->
                  <xsl:if test="@fenc">
                    <xsl:attribute name="fenc">true</xsl:attribute>
                  </xsl:if>
			<xsl:choose>
				<xsl:when test="@aid:pstyle='T_1'">
          <xsl:choose>
            <xsl:when test="parent::tei:div[@type='bibliographie']">
              <xsl:attribute name="aid:pstyle">T_a_biblio</xsl:attribute>
    					<xsl:attribute name="style">T_a_biblio</xsl:attribute>
            </xsl:when>
            <xsl:when test="parent::tei:div[@type='annexe']">
              <xsl:attribute name="aid:pstyle">ann_T_a</xsl:attribute>
    					<xsl:attribute name="style">ann_T_a</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
					<xsl:attribute name="aid:pstyle">T_a</xsl:attribute>
					<xsl:attribute name="style">T_a</xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
				</xsl:when>
				<xsl:when test="@aid:pstyle='T_2'">
					<xsl:choose>
						<xsl:when test="parent::tei:div[preceding-sibling::tei:div[@type='section2'] or preceding-sibling::tei:p or preceding-sibling::tei:epigraph or preceding-sibling::tei:quote or preceding-sibling::tei:item]|parent::tei:listBibl[preceding-sibling::tei:listBibl]">
							<xsl:attribute name="aid:pstyle">T_b</xsl:attribute>
							<xsl:attribute name="style">T_b</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="aid:pstyle">T_b_apres_T_a</xsl:attribute>
							<xsl:attribute name="style">T_b_apres_T_a</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="@aid:pstyle='T_3'">
					<xsl:choose>
						<xsl:when test="parent::tei:div[preceding-sibling::tei:div[@type='section3'] or preceding-sibling::tei:p or preceding-sibling::tei:epigraph or preceding-sibling::tei:quote or preceding-sibling::tei:item]">
							<xsl:attribute name="aid:pstyle">T_c</xsl:attribute>
							<xsl:attribute name="style">T_c</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="aid:pstyle">T_c_apres_T_b</xsl:attribute>
							<xsl:attribute name="style">T_c_apres_T_b</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="@aid:pstyle='T_4'">
					<xsl:choose>
						<xsl:when test="parent::tei:div[preceding-sibling::tei:div[@type='section4'] or preceding-sibling::tei:p or preceding-sibling::tei:epigraph or preceding-sibling::tei:quote or preceding-sibling::tei:item]">
							<xsl:attribute name="aid:pstyle">T_d</xsl:attribute>
							<xsl:attribute name="style">T_d</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="aid:pstyle">T_d_apres_T_c</xsl:attribute>
							<xsl:attribute name="style">T_d_apres_T_c</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="@aid:pstyle='T_5'">
          <xsl:choose>
						<xsl:when test="parent::tei:div[preceding-sibling::tei:div[@type='section5'] or preceding-sibling::tei:p or preceding-sibling::tei:epigraph or preceding-sibling::tei:quote or preceding-sibling::tei:item]">
							<xsl:attribute name="aid:pstyle">T_e</xsl:attribute>
							<xsl:attribute name="style">T_e</xsl:attribute>
						</xsl:when>
            <xsl:when test="parent::tei:div[@type='section5'][not(preceding-sibling::tei:*)]">
					<xsl:attribute name="aid:pstyle">T_e</xsl:attribute>
							<xsl:attribute name="style">T_e</xsl:attribute>
            </xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="aid:pstyle">T_e_apres_T_d</xsl:attribute>
							<xsl:attribute name="style">T_e_apres_T_d</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
        		<xsl:when test="@aid:pstyle='T_6'">
					<xsl:attribute name="aid:pstyle">T_f</xsl:attribute>
				</xsl:when>
       			<xsl:when test="@aid:pstyle='T_7'">
					<xsl:attribute name="aid:pstyle">T_g</xsl:attribute>
				</xsl:when>
       			<xsl:when test="@aid:pstyle='T_8'">
					<xsl:attribute name="aid:pstyle">T_h</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="./@*"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates/>
		</xsl:element>
		<xsl:choose>
			<!--xsl:when test="local-name(parent::node())='figure'">
			</xsl:when-->
			<xsl:when test=" (parent::node())='figure'">
			</xsl:when>
			<xsl:otherwise>
			<xsl:text>
</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:when>
        <xsl:when test="local-name()='item'">
          <xsl:choose>
            <xsl:when test="tei:lb">
              <xsl:text disable-output-escaping="yes">&lt;item aid:pstyle="</xsl:text><xsl:value-of select="@aid:pstyle"/><xsl:text disable-output-escaping="yes">"&gt;</xsl:text>
              <xsl:apply-templates/>
              <xsl:text disable-output-escaping="yes">&lt;/item&gt;</xsl:text>
	<xsl:text>
</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:copy>
                <xsl:apply-templates select="@*|node()"/>
              </xsl:copy>
              <xsl:if test="not(position()=last()) or not(local-name(following::*[1])='item')">
	<xsl:text>
</xsl:text>
              </xsl:if>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
	<xsl:otherwise>
		<xsl:copy>
			<xsl:apply-templates select="./@*"/>
			<xsl:apply-templates/>
                      </xsl:copy>
                  <xsl:text>
</xsl:text>
	</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- poésie -->
<xsl:template match="tei:caesura"><xsl:text>&#00009;</xsl:text></xsl:template>

<xsl:template match="tei:l">
	<xsl:text>
</xsl:text>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="tei:emph">
	<hi rend="italic"><xsl:apply-templates/></hi>
</xsl:template>

<xsl:template match="tei:graphic">
  <xsl:choose>
    <xsl:when test="local-name(parent::node()) != 'figure'"><graphic type="img_inline" href="{@url}"/></xsl:when>
    <xsl:otherwise><graphic href="{@url}"/></xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="tei:table">
	<xsl:element name="Tableau">
		<xsl:attribute name="aid:table">table</xsl:attribute>
		<xsl:choose>
			<xsl:when test="./parent::tei:cell">
				<xsl:attribute name="aid5:tablestyle">
					<xsl:text>tableau-enchasse</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="aid5:tablestyle">
					<xsl:text>tableau-principal</xsl:text>
				</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:attribute name="aid:trows"><xsl:value-of select="count(./tei:row)"/></xsl:attribute>
		<xsl:attribute name="aid:tcols"><xsl:value-of select="@aid:tcols"/></xsl:attribute>
	<xsl:apply-templates/>
	</xsl:element><xsl:text>
</xsl:text>
</xsl:template>

<xsl:template match="tei:row">
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="tei:cell">
	<xsl:element name="Cellule">
		<xsl:attribute name="aid:table">cell</xsl:attribute>
		<xsl:attribute name="rend"><xsl:value-of select="@rend"/></xsl:attribute>
		<xsl:choose>
			<xsl:when test="@aid:cell-style='cell-tetiere'">
				<xsl:attribute name="aid5:cellstyle">
					<xsl:text>cell-tetiere</xsl:text>
				</xsl:attribute>
				<xsl:attribute name="aid:theader"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="aid5:cellstyle">
					<xsl:text>cellule-standard</xsl:text>
				</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:attribute name="aid:pstyle">Cellule</xsl:attribute>
		<xsl:choose>
			<xsl:when test="./*[1][self::tei:hi[@rend='bold']]">
				<xsl:attribute name="aid:pstyle">tetiere</xsl:attribute>
				<xsl:attribute name="aid5:cellstyle">
					<xsl:text>cellule-tetiere</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:when test="./*[1][self::tei:hi[@rend='tetiere']]">
				<xsl:attribute name="aid:pstyle">tetiere</xsl:attribute>
				<xsl:attribute name="aid5:cellstyle">
					<xsl:text>cellule-tetiere</xsl:text>
				</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="aid:pstyle">texte-tab</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:attribute name="aid:crows">
			<xsl:choose>
				<xsl:when test="./@rows"><xsl:value-of select="./@rows"/></xsl:when>
				<xsl:otherwise>1</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
		<xsl:attribute name="aid:ccols">
			<xsl:choose>
				<xsl:when test="./@cols"><xsl:value-of select="./@cols"/></xsl:when>
				<xsl:otherwise>1</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
		 <xsl:choose>
            <xsl:when test=".[@aid:theader]">
                <xsl:attribute name="aid:theader"></xsl:attribute>
            </xsl:when>
            <xsl:otherwise></xsl:otherwise>
        </xsl:choose>
		<xsl:apply-templates/>
	</xsl:element>
</xsl:template>

<xsl:template match="tei:cell/tei:hi[@rend='bold']">
	<xsl:element name="emph">
		<xsl:attribute name="aid:cstyle">gras tableau</xsl:attribute>
		<xsl:apply-templates select="./*|text()"/>
	</xsl:element>
</xsl:template>

<xsl:template match="tei:cell/tei:emph">
	<xsl:element name="emph">
		<xsl:attribute name="aid:cstyle">italique tableau</xsl:attribute>
		<xsl:apply-templates select="./*|text()"/>
	</xsl:element>
</xsl:template>

<xsl:template match="tei:cell/tei:hi[@rend='bold']/tei:emph">
	<xsl:element name="emph">
		<xsl:attribute name="aid:cstyle">italique gras tableau</xsl:attribute>
		<xsl:apply-templates select="./*|text()"/>
	</xsl:element>
</xsl:template>


<!-- Gestion des images avec choix d'importation : en tableau ou libre -->
<xsl:template match="tei:figure">
    <xsl:if test="@xml:id"><anchor id="{@xml:id}"/></xsl:if>
<xsl:choose>
<xsl:when test="$figuresMode='tab'">
  <p aid:pstyle="tableau-figure">
  	<xsl:attribute name="titre">
  		<xsl:value-of select="substring(translate(tei:head,' éè. ôœ’«»','_'),1,25)"/>
  	</xsl:attribute>
  <Tableau aid:table="table">
    <xsl:choose>
<!-- titre + graphic (+ légende, crédits) -->
      <xsl:when test="$figuresVert='figTitleUp'">
          <xsl:attribute name="aid:tcols">1</xsl:attribute>  
          <xsl:attribute name="aid:trows">
            <xsl:choose>
              <xsl:when test="child::tei:p">3</xsl:when>
              <xsl:otherwise>2</xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
          <xsl:attribute name="aid5:tablestyle">tableau-figure</xsl:attribute>
       <Cellule aid:table="cell" aid5:cellstyle="cellule-titre">
        <xsl:copy-of select="tei:head"/>
       </Cellule>
       <Cellule aid:table="cell" aid5:cellstyle="cellule-figure">
          <xsl:for-each select="tei:graphic">
              <anchor type="link">
              <xsl:attribute name="id">
               <xsl:value-of select="substring-before(substring-after(@url,'r/'),'.')"/>
            </xsl:attribute>
            </anchor>
          <graphic aid:pstyle="txt_Figure">
                <xsl:attribute name="href">
                    <xsl:value-of select="@url"/>
                </xsl:attribute>
          </graphic>
          </xsl:for-each>
       </Cellule>
      <xsl:if test="child::tei:p">
      <Cellule aid:table="cell" aid5:cellstyle="cellule-legende"><xsl:for-each select="tei:p"><xsl:if test="./@style='txt_credits'"><xsl:text>
</xsl:text></xsl:if><xsl:copy-of select="."/></xsl:for-each></Cellule></xsl:if>  
      </xsl:when>
<!-- graphic + titre, légende,crédits -->
      <xsl:when test="$figuresVert='beforeTitle'">
        <xsl:attribute name="aid:tcols">1</xsl:attribute>
        <xsl:attribute name="aid:trows">2</xsl:attribute>
        <xsl:attribute name="aid5:tablestyle">tableau-figure</xsl:attribute>
        
      <Cellule aid:table="cell" aid5:cellstyle="cellule-figure">
      <xsl:for-each select="tei:graphic">
          <anchor type="link">
              <xsl:attribute name="id">
               <xsl:value-of select="substring-before(substring-after(@url,'r/'),'.')"/>
            </xsl:attribute>
          </anchor>
      <graphic aid:pstyle="txt_Figure">
            <xsl:attribute name="href">
          <xsl:value-of select="@url"/>
            </xsl:attribute>
      </graphic>
      </xsl:for-each>
    </Cellule>
    <Cellule aid:table="cell" aid5:cellstyle="cellule-titre-legende">
      <xsl:copy-of select="tei:head"/><xsl:if test="tei:p"><xsl:for-each select="tei:p"><xsl:text>
</xsl:text><xsl:copy-of select="."/></xsl:for-each></xsl:if><xsl:if test="tei:quote"><xsl:text>
</xsl:text><xsl:for-each select="tei:quote/tei:*"><xsl:apply-templates select="."/><xsl:text>
</xsl:text></xsl:for-each></xsl:if></Cellule>
      </xsl:when>
<!-- tableau horizontal : image à gauche, texte à droite -->        
      <xsl:otherwise>
        <xsl:attribute name="aid:tcols">2</xsl:attribute>
        <xsl:attribute name="aid:trows">1</xsl:attribute>
        <xsl:attribute name="aid5:tablestyle">tableau-figure</xsl:attribute>
        
        <Cellule aid:table="cell" aid5:cellstyle="cellule-figure">
      <xsl:for-each select="tei:graphic">
          <anchor type="link">
              <xsl:attribute name="id">
               <xsl:value-of select="substring-before(substring-after(@url,'r/'),'.')"/>
            </xsl:attribute>
          </anchor>
      <graphic aid:pstyle="txt_Figure">
            <xsl:attribute name="href">
          <xsl:value-of select="@url"/>
            </xsl:attribute>
      </graphic>
      </xsl:for-each>
    </Cellule>
    <Cellule aid:table="cell" aid5:cellstyle="cellule-titre-legende">
      <xsl:copy-of select="tei:head"/><xsl:if test="tei:p"><xsl:for-each select="tei:p"><xsl:text>
</xsl:text><xsl:copy-of select="."/></xsl:for-each></xsl:if></Cellule>
          
      </xsl:otherwise>
    </xsl:choose>
  </Tableau></p>
  <xsl:text>
</xsl:text>
</xsl:when>
<xsl:when test="$figuresMode='heap'">
  <xsl:for-each select="tei:graphic">
      <anchor type="link">
              <xsl:attribute name="id">
               <xsl:value-of select="substring-before(substring-after(@url,'r/'),'.')"/>
            </xsl:attribute>
          </anchor>
	<graphic>
		<xsl:attribute name="href">
        	<xsl:value-of select="./@url"/>
    	</xsl:attribute>
    </graphic></xsl:for-each><xsl:apply-templates select="./tei:head"/>
    <xsl:apply-templates select="./tei:p[contains(@aid:pstyle,'txt_Legende')]"/>
    <xsl:if test="./tei:p[contains(@aid:pstyle,'credits')]">
      <xsl:apply-templates select="./tei:p[contains(@aid:pstyle,'credits')]"/>
    </xsl:if>
</xsl:when>
<xsl:when test="$figuresMode='cell'">
  <figure>
    <xsl:attribute name="titre">
  		<xsl:value-of select="substring(translate(tei:head,' éè. ôœ’«»','_'),1,25)"/>
  	</xsl:attribute>
    <xsl:for-each select="tei:graphic">
        <anchor type="link">
              <xsl:attribute name="id">
               <xsl:value-of select="substring-before(substring-after(@url,'r/'),'.')"/>
            </xsl:attribute>
          </anchor>
	<graphic aid:pstyle="txt_Figure">
		<xsl:attribute name="href">
        	<xsl:value-of select="./@url"/>
    	</xsl:attribute>
    </graphic></xsl:for-each><xsl:text>
</xsl:text><xsl:apply-templates select="./tei:head"/>
    <xsl:apply-templates select="./tei:p[@aid:pstyle='txt_Legende']"/>
    <xsl:apply-templates select="./tei:p[contains(@aid:pstyle,'credits')]"/>
  </figure>
</xsl:when>
</xsl:choose>
</xsl:template>

<xsl:template match="tei:head[parent::tei:figure]">
    <head>
        <xsl:copy-of select="@*"/>
        <xsl:attribute name="id"><xsl:value-of select="substring-after(preceding::tei:graphic[1]/@url,'r/')"/></xsl:attribute>
        <xsl:apply-templates/>
    </head><xsl:text>
</xsl:text>
</xsl:template>
    
<xsl:template match="tei:cit[@type='linguistic']/tei:quote">
  <xsl:choose>
    <xsl:when test="child::*:quote[@type='example']">
      <xsl:element name="Tableau">
        <xsl:attribute name="aid:table">table</xsl:attribute>
        <xsl:attribute name="aid5:tablestyle">
          <xsl:text>tableau-exemple-commons</xsl:text>
        </xsl:attribute>
        <xsl:choose>
          <xsl:when test="child::*:label">
            <xsl:attribute name="aid:tcols"><xsl:value-of select="count(child::*:quote[@type='example'][1]/tei:seg)+1"/></xsl:attribute>
            <xsl:attribute name="aid:trows"><xsl:value-of select="count(child::*)"/></xsl:attribute>
          </xsl:when>
          <xsl:when test="child::*:num">
            <xsl:attribute name="aid:tcols"><xsl:value-of select="count(child::*:quote[@type='example'][1]/tei:seg)+1"/></xsl:attribute>
            <xsl:attribute name="aid:trows"><xsl:value-of select="count(child::*)-1"/></xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
           <xsl:attribute name="aid:tcols"><xsl:value-of select="count(child::*:quote[@type='example'][1]/tei:seg)"/></xsl:attribute>
            <xsl:attribute name="aid:trows"><xsl:value-of select="count(child::*)"/></xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        
        <xsl:apply-templates/>
      </xsl:element><xsl:text>
</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates/><xsl:text>
</xsl:text>
    </xsl:otherwise>
  </xsl:choose>

</xsl:template>

<xsl:template match="tei:cit[@type='linguistic']//tei:quote[@type='trl']|tei:cit[@type='linguistic']//tei:quote[@type='example']|tei:cit[@type='linguistic']//tei:gloss|tei:cit[@type='linguistic']/tei:bibl">
  <xsl:choose>
    <xsl:when test="local-name()='bibl'">
      <xsl:choose>
        <xsl:when test="preceding-sibling::tei:quote/tei:num">
          <xsl:element name="Cellule">
            <xsl:attribute name="aid:table">cell</xsl:attribute>
            <xsl:attribute name="aid5:cellstyle">
              <xsl:text>cellule-numExemple</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="aid:pstyle">Cellule-numExemple</xsl:attribute>
            <xsl:attribute name="aid:crows">1</xsl:attribute>
            <xsl:attribute name="aid:ccols">1</xsl:attribute>
            <xsl:text> </xsl:text>
          </xsl:element>
          <xsl:element name="Cellule">
            <xsl:attribute name="aid:table">cell</xsl:attribute>
            <xsl:attribute name="aid5:cellstyle">
              <xsl:text>cellule-standard</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="aid:crows">1</xsl:attribute>
            <xsl:attribute name="aid:ccols">1</xsl:attribute>
            <xsl:apply-templates/>
          </xsl:element>
        </xsl:when>
        <xsl:otherwise/>
      </xsl:choose>
    </xsl:when>
    <xsl:when test="@aid:pstyle='txt_Exemple'">
      <xsl:element name="quote">
        <xsl:attribute name="aid:pstyle">txt_Exemple</xsl:attribute>
        <xsl:apply-templates/>
      </xsl:element><xsl:text>
</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="tei:cit[@type='linguistic']/tei:quote/tei:num">
  	<xsl:element name="Cellule">
          <xsl:attribute name="aid:table">cell</xsl:attribute>
          <xsl:attribute name="aid5:cellstyle">
            <xsl:text>cellule-numExemple</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="aid:pstyle">Cellule-numExemple</xsl:attribute>
          <xsl:attribute name="aid:crows"><xsl:value-of select="count(parent::*:quote/child::*)-1"/></xsl:attribute>
          <xsl:attribute name="aid:ccols">1</xsl:attribute>
          <xsl:apply-templates/>
        </xsl:element>
</xsl:template>

<xsl:template match="tei:cit[@type='linguistic']/tei:quote/tei:label">
<xsl:for-each select="child::*:num">
      	<xsl:element name="Cellule">
          <xsl:attribute name="aid:table">cell</xsl:attribute>
          <xsl:attribute name="aid5:cellstyle">
            <xsl:text>cellule-numExemple</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="aid:pstyle">Cellule-numExemple</xsl:attribute>
          <xsl:attribute name="aid:crows"><xsl:value-of select="count(ancestor::*:quote/child::*)"/></xsl:attribute>
          <xsl:attribute name="aid:ccols">1</xsl:attribute>
          <xsl:apply-templates select="."/>
    </xsl:element>
</xsl:for-each>
    	<xsl:element name="Cellule">
          <xsl:attribute name="aid:table">cell</xsl:attribute>
          <xsl:attribute name="aid5:cellstyle">
            <xsl:text>cellule-numExemple</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="aid:pstyle">Cellule-numExemple</xsl:attribute>
          <xsl:attribute name="aid:crows">1</xsl:attribute>
          <xsl:attribute name="aid:ccols"><xsl:value-of select="count(ancestor::*:quote/*:quote[@type='example'][1]/tei:seg)"/></xsl:attribute>
          <xsl:apply-templates select="node()[not(self::*:num)]"/>
    </xsl:element>
</xsl:template>


<xsl:template match="tei:cit[@type='linguistic']/tei:quote/tei:quote[@type='trl']">
  	<xsl:element name="Cellule">
          <xsl:attribute name="aid:table">cell</xsl:attribute>
          <xsl:attribute name="aid5:cellstyle">
            <xsl:text>cellule-traduction</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="aid:pstyle">Cellule-traduction</xsl:attribute>
          <xsl:attribute name="aid:crows">1</xsl:attribute>
          <xsl:attribute name="aid:ccols"><xsl:value-of select="count(ancestor::*:quote/*:quote[@type='example'][1]/tei:seg)"/></xsl:attribute>
          <xsl:apply-templates/>
        </xsl:element>
</xsl:template>

<xsl:template match="tei:cit[@type='linguistic']/tei:quote/tei:p">
  	<xsl:element name="Cellule">
          <xsl:attribute name="aid:table">cell</xsl:attribute>
          <xsl:attribute name="aid5:cellstyle">
            <xsl:text>cellule-parag</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="aid:pstyle">Cellule-parag</xsl:attribute>
          <xsl:attribute name="aid:crows">1</xsl:attribute>
          <xsl:attribute name="aid:ccols"><xsl:value-of select="count(ancestor::*:quote/*:quote[@type='example'][1]/tei:seg)"/></xsl:attribute>
          <xsl:apply-templates/>
        </xsl:element>
</xsl:template>

<xsl:template match="tei:cit[@type='linguistic']/tei:quote/tei:bibl">
  	<xsl:element name="Cellule">
          <xsl:attribute name="aid:table">cell</xsl:attribute>
          <xsl:attribute name="aid5:cellstyle">
            <xsl:text>cellule-sourcesg</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="aid:pstyle">Cellule-sourcesg</xsl:attribute>
          <xsl:attribute name="aid:crows">1</xsl:attribute>
          <xsl:attribute name="aid:ccols"><xsl:value-of select="count(ancestor::*:quote/*:quote[@type='example'][1]/tei:seg)"/></xsl:attribute>
          <xsl:apply-templates/>
        </xsl:element>
</xsl:template>

<xsl:template match="tei:cit[@type='linguistic']/tei:quote/tei:quote[@type='example']/tei:seg">
  <xsl:element name="Cellule">
    <xsl:attribute name="aid:table">cell</xsl:attribute>
    <xsl:attribute name="aid5:cellstyle">
      <xsl:text>cellule-segment</xsl:text>
    </xsl:attribute>
    <xsl:attribute name="aid:pstyle">Cellule-segment</xsl:attribute>
    <xsl:attribute name="aid:crows">1</xsl:attribute>
    <xsl:attribute name="aid:ccols">1</xsl:attribute>
    <xsl:apply-templates/>
  </xsl:element>
</xsl:template>
  
  <xsl:template match="tei:cit[@type='linguistic']/tei:quote/tei:gloss">
    <xsl:choose>
      <xsl:when test="child::*:seg">
      <xsl:for-each select="child::*:seg">
             <xsl:element name="Cellule">
          <xsl:attribute name="aid:table">cell</xsl:attribute>
          <xsl:attribute name="aid5:cellstyle">
            <xsl:text>cellule-glose</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="aid:pstyle">Cellule-glose</xsl:attribute>
          <xsl:attribute name="aid:crows">1</xsl:attribute>
          <xsl:attribute name="aid:ccols">1</xsl:attribute>
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="Cellule">
          <xsl:attribute name="aid:table">cell</xsl:attribute>
          <xsl:attribute name="aid5:cellstyle">
            <xsl:text>cellule-glose</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="aid:pstyle">Cellule-glose</xsl:attribute>
          <xsl:attribute name="aid:crows">1</xsl:attribute>
          <xsl:attribute name="aid:ccols"><xsl:value-of select="count(ancestor::*:quote/*:quote[@type='example'][1]/tei:seg)"/></xsl:attribute>
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
<xsl:template match="tei:hi[ancestor::tei:cit[@type='linguistic'] and not(@style)]">
		<xsl:copy>
			<xsl:variable name="rend" select="@rend" />
			<xsl:attribute name="style" select="concat('typo_',$typoRef//*:style[@eq=$rend])" />
            <xsl:attribute name="aid:cstyle" select="concat('typo_',$typoRef//*:style[@eq=$rend])" />
			<xsl:attribute name="rend" select="if($rend='strikethrough') then('line-through') else($rend)" />
			<xsl:apply-templates select="node()" />
		</xsl:copy>
	</xsl:template>
    
  <xsl:template match="*:bibl[@style='txt_Sources']">
    <xsl:choose>
      <xsl:when test="ancestor::*:epigraph">
        <xsl:text>
</xsl:text>
        <p aid:pstyle="txt_Sources" style="txt_Sources"> 
          <xsl:apply-templates select="node()"/>
        </p> 
      </xsl:when>
      <xsl:otherwise>
        <p aid:pstyle="txt_Sources" style="txt_Sources"> 
          <xsl:apply-templates select="node()"/>
        </p>  
        <xsl:text>
</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

<xsl:template match="*:bibl[@rend='typo_Sources']">
  <hi aid:cstyle="typo_Sources" style="typo_Sources"> 
    <xsl:apply-templates select="node()"/>
  </hi>
</xsl:template>

<xsl:template match="tei:lb">
  <xsl:variable name="listStyle"><xsl:value-of select="../@aid:pstyle"/></xsl:variable>
  <xsl:choose>
    <xsl:when test="local-name(parent::node()) = 'note'">
      <xsl:if test="not(position()=last())">
	  <xsl:text>
</xsl:text>
      </xsl:if>
    </xsl:when>
      <xsl:when test="local-name(parent::node()) = 'p'">
        <xsl:text>
</xsl:text>
      </xsl:when>
      <xsl:when test="local-name(parent::node()) = 'bibl'">
        <xsl:text>
</xsl:text>
      </xsl:when>
      <xsl:when test="local-name(parent::node()) = 'cell'">
        <xsl:text>
</xsl:text>
      </xsl:when>
      <xsl:when test="local-name(parent::node()) = 'seg'">
        <xsl:text>
</xsl:text>
      </xsl:when>
      <xsl:when test="local-name(parent::node()) = 'l'"><xsl:text>
</xsl:text>
      </xsl:when>
       <xsl:when test="local-name(parent::node()) = 'hi'">
        <xsl:text>
</xsl:text>
      </xsl:when>
    <xsl:when test="local-name(parent::node()) != 'item'">
      <!--xsl:text>
</xsl:text-->
<xsl:text disable-output-escaping="yes"></xsl:text>
    </xsl:when>
    <xsl:when test="not(preceding-sibling::tei:lb)">
      <xsl:text disable-output-escaping="yes">&lt;/item&gt;
</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;item aid:pstyle="</xsl:text><xsl:value-of select="$listStyle"/><xsl:text disable-output-escaping="yes">suite"&gt;</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text disable-output-escaping="yes">&lt;/item&gt;
</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;item aid:pstyle="</xsl:text><xsl:value-of select="$listStyle"/><xsl:text disable-output-escaping="yes">suite"&gt;</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="tei:quote[@rend='rtl']">
	<quote rend="rtl" aid:pstyle="txt_Citation_inv">
		<xsl:apply-templates/>
	</quote><xsl:text>
</xsl:text>
</xsl:template>

<xsl:template match="tei:epigraph">
	<epigraph aid:pstyle="txt_Epigraphe">
		<xsl:apply-templates/>
	</epigraph><xsl:text>
</xsl:text>
</xsl:template>

<xsl:template match="tei:bibl[not(@rend='inline')]">
    <xsl:choose>
        <xsl:when test="preceding-sibling::*[1][local-name()='head']"></xsl:when>
        <xsl:otherwise><xsl:text>
</xsl:text></xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
        <xsl:when test="ancestor::tei:cit[@type='linguistic']">
            <xsl:element name="Cellule">
                  <xsl:attribute name="aid:table">cell</xsl:attribute>
                  <xsl:attribute name="aid5:cellstyle">
                    <xsl:text>cellule-sources</xsl:text>
                  </xsl:attribute>
                  <xsl:attribute name="aid:pstyle">Cellule-sources</xsl:attribute>
                  <xsl:attribute name="aid:crows">1</xsl:attribute>
                  <xsl:attribute name="aid:ccols"><xsl:value-of select="count(ancestor::*:quote/*:quote[@type='example'][1]/tei:seg)"/></xsl:attribute>
                  <xsl:apply-templates/>
            </xsl:element>
        </xsl:when>
        <xsl:otherwise>
          <bibl>
                <xsl:copy-of select="@*"/>
                <xsl:attribute name="aid:pstyle">
                    <xsl:choose>
                        <xsl:when test="parent::tei:epigraph">txt_Epigraphe_sources</xsl:when>
                        <xsl:when test="parent::tei:quote">
                            <xsl:variable name="parentStyle" select="parent::tei:quote/@style"/>
                            <xsl:value-of select="concat($parentStyle,'_sources')"/>
                        </xsl:when>
                        <xsl:otherwise>txt_Bibliographie</xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
                <xsl:apply-templates/>
            </bibl>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="tei:quote[@rend='quotation']|tei:quote[@rend='quotation2']">
<xsl:choose>
 <xsl:when test="tei:lb">
   <quote rend="quotation" aid:pstyle="txt_Citation_debut">
     <xsl:for-each select="tei:lb[1]/preceding-sibling::*|tei:lb[1]/preceding-sibling::text()">
       <xsl:apply-templates select="."/>
     </xsl:for-each>
   </quote><xsl:text>
</xsl:text>
   <xsl:variable name="finCitation">
     <xsl:for-each select="tei:lb[1]/following-sibling::*|tei:lb[1]/following-sibling::text()">
       <xsl:copy-of select="."/>
     </xsl:for-each>
   </xsl:variable>

   <xsl:call-template name="citationSuite">
     <xsl:with-param name="rest" select="$finCitation"/>
   </xsl:call-template>
 </xsl:when>
  <xsl:when test="parent::tei:quote">
    <xsl:text>
  </xsl:text>
   <quote rend="quotation" aid:pstyle="txt_Citation_debut">
     <xsl:copy-of select="@aid:pstyle"/>
       <xsl:copy-of select="@rend"/>
     <xsl:apply-templates/>
   </quote>
  </xsl:when>
  <xsl:when test="parent::tei:p and not(@style='typo_Citation')">
    <quote rend="quotation" aid:pstyle="txt_Citation_debut">
      <xsl:copy-of select="@aid:pstyle"/>
        <xsl:copy-of select="@rend"/>
      <xsl:apply-templates/>
    </quote>
 </xsl:when>
   <xsl:when test="descendant::tei:lg and following-sibling::tei:quote">
    <quote rend="quotation">
      <xsl:copy-of select="@aid:pstyle"/>
        <xsl:copy-of select="@rend"/>
      <xsl:apply-templates/>
    </quote>
 </xsl:when>
 <xsl:otherwise>
   <quote>
       <xsl:copy-of select="@aid:pstyle"/>
       <xsl:copy-of select="@rend"/>
     <xsl:apply-templates/>
   </quote><xsl:text>
</xsl:text>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template name="citationSuite">
  <xsl:param name="rest" select="rest"/>
  <xsl:choose>
    <xsl:when test="$rest/descendant::tei:lb[not(ancestor::tei:note)]">
      <quote rend="quotation" aid:pstyle="txt_Citation_suite">
        <xsl:for-each select="$rest/tei:lb[1]/preceding-sibling::*|$rest/tei:lb[1]/preceding-sibling::text()">
          <xsl:apply-templates select="."/>
        </xsl:for-each>
      </quote><xsl:text>
</xsl:text>
      <xsl:variable name="finCitation">
        <xsl:for-each select="$rest/tei:lb[1]/following-sibling::*|$rest/tei:lb[1]/following-sibling::text()">
          <xsl:copy-of select="."/>
        </xsl:for-each>
      </xsl:variable>

      <xsl:call-template name="citationSuite">
        <xsl:with-param name="rest" select="$finCitation"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <quote rend="quotation" aid:pstyle="txt_Citation_fin">
        <xsl:apply-templates select="$rest"/>
      </quote><xsl:text>
</xsl:text>
  </xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="tei:quote[contains(@rend,'italique')]">
<xsl:choose>
 <xsl:when test="tei:lb">
   <quote rend="quotation" aid:pstyle="txt_Citation_italique_debut">
     <xsl:for-each select="tei:lb[1]/preceding-sibling::*|tei:lb[1]/preceding-sibling::text()">
       <xsl:apply-templates select="."/>
     </xsl:for-each>
   </quote><xsl:text>
</xsl:text>
   <xsl:variable name="finCitation">
     <xsl:for-each select="tei:lb[1]/following-sibling::*|tei:lb[1]/following-sibling::text()">
       <xsl:copy-of select="."/>
     </xsl:for-each>
   </xsl:variable>

   <xsl:call-template name="citationSuiteItal">
     <xsl:with-param name="rest" select="$finCitation"/>
   </xsl:call-template>
 </xsl:when>
    <xsl:when test="descendant::tei:lg and following-sibling::tei:quote">
    <quote rend="quotation">
      <xsl:copy-of select="@aid:pstyle"/>
        <xsl:copy-of select="@rend"/>
      <xsl:apply-templates/>
    </quote>
 </xsl:when>
 <xsl:otherwise>
   <quote>
       <xsl:copy-of select="@aid:pstyle"/>
       <xsl:copy-of select="@rend"/>
     <xsl:apply-templates/>
   </quote><xsl:text>
</xsl:text>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template name="citationSuiteItal">
  <xsl:param name="rest" select="rest"/>
  <xsl:choose>
    <xsl:when test="$rest/descendant::tei:lb[not(ancestor::tei:note)]">
      <quote rend="quotation" aid:pstyle="txt_Citation_italique_suite">
        <xsl:for-each select="$rest/tei:lb[1]/preceding-sibling::*|$rest/tei:lb[1]/preceding-sibling::text()">
          <xsl:apply-templates select="."/>
        </xsl:for-each>
      </quote><xsl:text>
</xsl:text>
      <xsl:variable name="finCitation">
        <xsl:for-each select="$rest/tei:lb[1]/following-sibling::*|$rest/tei:lb[1]/following-sibling::text()">
          <xsl:copy-of select="."/>
        </xsl:for-each>
      </xsl:variable>

      <xsl:call-template name="citationSuiteItal">
        <xsl:with-param name="rest" select="$finCitation"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <quote rend="quotation" aid:pstyle="txt_Citation_italique_fin">
        <xsl:apply-templates select="$rest"/>
      </quote><xsl:text>
</xsl:text>
  </xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="tei:quote[@style='typo_Citation']">
	<quote rend="quotation" aid:cstyle="typo_Citation">
		<xsl:apply-templates/>
	</quote>
</xsl:template>

<!-- recension block -->
<xsl:template match="tei:div[@type='recension']/tei:ab[@type='pp']"/>

<xsl:template match="tei:docAuthor[@aid:pstyle='auteur_recension']/tei:name">
  <xsl:choose>
    <xsl:when test="following-sibling::tei:affiliation[1]">
      <name aid:pstyle="auteur_recension"><xsl:apply-templates/></name><xsl:text>
    </xsl:text><affiliation aid:pstyle="auteur_recension_affiliation"><xsl:apply-templates select="following-sibling::tei:affiliation[1]/node()"/></affiliation>
    </xsl:when>
    <xsl:otherwise>
      <name aid:pstyle="auteur_recension"><xsl:apply-templates/></name>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="tei:docAuthor[@aid:pstyle='auteur_recension']/tei:affiliation"/>

<xsl:template match="tei:note[@place='end']">
    <xsl:choose>
        <xsl:when test="$endnote='true'">
            <ref aid:cstyle="typo_appel_NoteFin" type="link" target="#ref{./@xml:id}"><xsl:value-of select="./@n"/></ref><anchor type="link" id="{@xml:id}"/>
        </xsl:when>
        <xsl:otherwise>
            <note>
                <xsl:copy-of select="@*"/>
                <xsl:attribute name="place">end-indd</xsl:attribute>
                <xsl:apply-templates/>
            </note>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="//tei:div[@type='annexe'][not(child::*:ab)]//*[@aid:pstyle][not(self::*:head[1]) and not(self::*:note)]">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="aid:pstyle">
				<xsl:value-of select="concat('ann_',@aid:pstyle)"/>
			</xsl:attribute>
			<xsl:apply-templates/>
      <xsl:text>
</xsl:text>
		</xsl:copy>
	</xsl:template>

  <xsl:template match="//*:ab[@type='enc_encadre']//*[@aid:pstyle][not(self::*:note)]">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="aid:pstyle">
				<xsl:value-of select="concat('enc_',@aid:pstyle)"/>
			</xsl:attribute>
			<xsl:apply-templates/>
      <xsl:text>
</xsl:text>
		</xsl:copy>
	</xsl:template>


  <!-- LINGUISTIQUE V3 -->

  <xsl:template match="tei:quote[@type='exemple']">
  <xsl:choose>
    <xsl:when test="tei:quote/tei:seg">
      <xsl:element name="Tableau">
        <xsl:attribute name="aid:table">table</xsl:attribute>
        <xsl:attribute name="aid5:tablestyle">
          <xsl:text>tableau-exemple</xsl:text>
        </xsl:attribute>
        <xsl:attribute name="aid:trows"><xsl:value-of select="count(./tei:quote)+count(./tei:bibl)"/></xsl:attribute>
        <xsl:attribute name="aid:tcols"><xsl:value-of select="count(./tei:quote[1]/tei:seg)+count(./tei:quote[1]/tei:num)"/></xsl:attribute>
        <xsl:apply-templates/>
      </xsl:element><xsl:text>
</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates/><xsl:text>
</xsl:text>
    </xsl:otherwise>
  </xsl:choose>

</xsl:template>

<xsl:template match="tei:quote[@type='exemple']/tei:quote|tei:quote[@type='exemple']/tei:bibl">
  <xsl:choose>
    <xsl:when test="@type='glose' or local-name()='bibl'">
      <xsl:choose>
        <xsl:when test="preceding-sibling::tei:quote/tei:num">
          <xsl:element name="Cellule">
            <xsl:attribute name="aid:table">cell</xsl:attribute>
            <xsl:attribute name="aid5:cellstyle">
              <xsl:text>cellule-numExemple</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="aid:pstyle">Cellule-numExemple</xsl:attribute>
            <xsl:attribute name="aid:crows">1</xsl:attribute>
            <xsl:attribute name="aid:ccols">1</xsl:attribute>
            <xsl:text> </xsl:text>
          </xsl:element>
          <xsl:element name="Cellule">
            <xsl:attribute name="aid:table">cell</xsl:attribute>
            <xsl:attribute name="aid5:cellstyle">
              <xsl:text>cellule-standard</xsl:text>
            </xsl:attribute>
            <xsl:choose>
              <xsl:when test="@type='glose'">
                <xsl:attribute name="aid:pstyle">Cellule-glose</xsl:attribute>
              </xsl:when>
              <xsl:otherwise>
                <xsl:attribute name="aid:pstyle">Cellule-biblio</xsl:attribute>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:attribute name="aid:crows">1</xsl:attribute>
            <xsl:attribute name="aid:ccols"><xsl:value-of select="count(preceding-sibling::tei:quote[1]/tei:seg)"/></xsl:attribute>
            <xsl:apply-templates/>
          </xsl:element>
        </xsl:when>
        <xsl:otherwise>
          <!--xsl:element name="bibl">
            <xsl:attribute name="aid:pstyle">txt_Biblio</xsl:attribute>
            <xsl:apply-templates/>
          </xsl:element-->
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:when test="@aid:pstyle='txt_Exemple'">
      <xsl:element name="quote">
        <xsl:attribute name="aid:pstyle">txt_Exemple</xsl:attribute>
        <xsl:apply-templates/>
      </xsl:element><xsl:text>
</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="tei:quote[@type='exemple']/tei:quote/tei:num">
  	<xsl:element name="Cellule">
          <xsl:attribute name="aid:table">cell</xsl:attribute>
          <xsl:attribute name="aid5:cellstyle">
            <xsl:text>cellule-numExemple</xsl:text>
          </xsl:attribute>
          <xsl:attribute name="aid:pstyle">Cellule-numExemple</xsl:attribute>
          <xsl:attribute name="aid:crows">1</xsl:attribute>
          <xsl:attribute name="aid:ccols">1</xsl:attribute>
          <xsl:apply-templates/>
        </xsl:element>
</xsl:template>

<xsl:template match="tei:quote[@type='exemple']/tei:quote/tei:seg">
<xsl:choose>
  <xsl:when test="parent::tei:quote/preceding-sibling::tei:quote/tei:num and position()=1">
  <!-- <xsl:if test="parent::tei:quote/preceding-sibling::tei:quote[1]/tei:num and position()=1"> -->
    <xsl:element name="Cellule">
      <xsl:attribute name="aid:table">cell</xsl:attribute>
      <xsl:attribute name="aid5:cellstyle">
        <xsl:text>cellule-numExemple</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="aid:pstyle">Cellule-numExemple</xsl:attribute>
      <xsl:attribute name="aid:crows">1</xsl:attribute>
      <xsl:attribute name="aid:ccols">1</xsl:attribute>
      <xsl:text> </xsl:text>
    </xsl:element>
  </xsl:when>
  <xsl:otherwise/>
</xsl:choose>
  <xsl:element name="Cellule">
    <xsl:attribute name="aid:table">cell</xsl:attribute>
    <xsl:attribute name="aid5:cellstyle">
      <xsl:text>cellule-segment</xsl:text>
    </xsl:attribute>
    <xsl:attribute name="aid:pstyle">Cellule-segment</xsl:attribute>
    <xsl:attribute name="aid:crows">1</xsl:attribute>
    <xsl:attribute name="aid:ccols">1</xsl:attribute>
    <xsl:apply-templates/>
  </xsl:element>
</xsl:template>

</xsl:stylesheet>
