<?xml version="1.0" encoding="UTF-8"?>
<!--
					/**
					*  XSLT tei2indd
					*
					*  Copyright (c) 2009-2015
					*  Pôle Document Numérique
					*  Maison de la Recherche en Sciences Humaines
					*  Université de Caen Basse-Normandie
					*  Esplanade de la Paix
					*  Campus 1
					*  14032 Caen Cedex
					*
					*  This program is free software: you can redistribute it and/or modify
					*  it under the terms of the GNU General Public License as published by
					*  the Free Software Foundation, either version 3 of the License, or
					*  (at your option) any later version.
					*
					*  This program is distributed in the hope that it will be useful,
					*  but WITHOUT ANY WARRANTY; without even the implied warranty of
					*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
					*  GNU General Public License for more details.
					*  <http://www.gnu.org/licenses/>
					*
					*  See http://www.unicaen.fr/recherche/mrsh/document_numerique/equipe
					*      for a list of contributors
					*/
-->
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xhtml="http://www.w3.org/TR/xhtml/strict"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:aid="http://ns.adobe.com/AdobeInDesign/4.0/"
	xmlns:aid5="http://ns.adobe.com/AdobeInDesign/5.0/"
	xmlns:tei="http://www.tei-c.org/ns/1.0"
	xmlns:java="http://www.java.com"
	xmlns="http://www.tei-c.org/ns/1.0"
	xmlns:pddn="http://www.unicaen.fr/recherche/mrsh/document_numerique"
	xmlns:xi="http://www.w3.org/2001/XInclude"
	xmlns:mml="http://www.w3.org/1998/Math/MathML" 
	exclude-result-prefixes="tei pddn java"
	>
	
	<xsl:output method="xml" encoding="UTF-8" indent="no"/>
	
	
	
	<xsl:param name="table" select="table"/>
	<xsl:param name="resolution" select="resolution"/>
	<xsl:param name="iconoPath" select="iconoPath"/>
	<xsl:param name="notesTables" select="notesTables"/>
	<xsl:param name="endnote" select="endnote"/>
	<xsl:param name="titrePartie" select="titrePartie"/>
	
	<xsl:variable name="tagsDecl">
		<xsl:copy-of select="//tei:tagsDecl"/>
	</xsl:variable>
	
	<!-- Stockage des premiers éléments avec @style après un floatingText -->
	<xsl:variable name="firstParasAfterFT" select="//tei:floatingText/following::tei:*[@style][1][not(ancestor::tei:floatingText)][not(ancestor::tei:table)]"/>
	
	
	<xsl:function name="pddn:isInFirstParasAfterFT">
		<xsl:param name="nodeToCheck"/>
		<xsl:variable name="in">
			<xsl:for-each select="$firstParasAfterFT">
				<xsl:if test=".=$nodeToCheck">
					<xsl:value-of select="true()"/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:value-of select="$in"/>
	</xsl:function>
	<!--
						Fonction vérifiant que le fichier $file existe sur le système de fichiers.
						Java Binding: ne fonctionne qu'avec un SaxonB ou EE ou PE (pas avec une version HE).
	-->
	<xsl:function name="java:file-exists" xmlns:file="java.io.File" as="xs:boolean">
		<xsl:param name="file" as="xs:string"/>
		<xsl:sequence select="file:exists(file:new($file))"/>
	</xsl:function>
	
	<!--
						Retourne le chemin d'une l'image selon la résolution souhaitée.
						Pour une résolution HR:
						on retourne le chemin vers l'image avec une extension .tif, .eps ou .jpg
						Sinon (br ou mr):
						on retourne le chemin vers l'image au format jpg ou png
						Dans tous les cas, si aucune des extensions souhaitées n'existe, une chaine vide est retournée.
	-->
	<xsl:function name="pddn:getResolutionImagePath">
		<xsl:param name="originalPath"/>
		<xsl:variable name="imageName"><xsl:value-of select="substring-before(substring-after($originalPath,'r/'),'.')"/></xsl:variable>
		<!-- stockage des chemins possibles selon les différentes extensions -->
		<xsl:variable name="PNGImage"><xsl:value-of select="concat($iconoPath,'/',$imageName,'.png')"/></xsl:variable>
		<xsl:variable name="JPGImage"><xsl:value-of select="concat($iconoPath,'/',$imageName,'.jpg')"/></xsl:variable>
		<xsl:variable name="JPEGImage"><xsl:value-of select="concat($iconoPath,'/',$imageName,'.jpeg')"/></xsl:variable>
		<xsl:variable name="EPSImage"><xsl:value-of select="concat($iconoPath,'/',$imageName,'.eps')"/></xsl:variable>
		<xsl:variable name="TIFImage"><xsl:value-of select="concat($iconoPath,'/',$imageName,'.tif')"/></xsl:variable>
		<xsl:variable name="TIFFImage"><xsl:value-of select="concat($iconoPath,'/',$imageName,'.tiff')"/></xsl:variable>
		<xsl:variable name="SVGImage"><xsl:value-of select="concat($iconoPath,'/',$imageName,'.svg')"/></xsl:variable>
		
		<xsl:choose>
			<!-- Cas d'une résolution haute déf.-->
			<xsl:when test="$resolution='hr'">
				<xsl:choose>
					<!-- recherche de l'image en .tif-->
					<xsl:when test="java:file-exists($TIFImage)">
						<xsl:value-of select="concat('../icono/',$resolution,'/',$imageName,'.tif')"/>
					</xsl:when>
					<xsl:when test="java:file-exists($TIFFImage)">
						<xsl:value-of select="concat('../icono/',$resolution,'/',$imageName,'.tiff')"/>
					</xsl:when>
					<!-- sinon recherche de l'image en .eps-->
					<xsl:when test="java:file-exists($EPSImage)">
						<xsl:value-of select="concat('../icono/',$resolution,'/',$imageName,'.eps')"/>
					</xsl:when>
					<!-- sinon recherche de l'image en .jpg-->
					<xsl:when test="java:file-exists($JPGImage)">
						<xsl:value-of select="concat('../icono/',$resolution,'/',$imageName,'.jpg')"/>
					</xsl:when>
					<xsl:when test="java:file-exists($JPEGImage)">
						<xsl:value-of select="concat('../icono/',$resolution,'/',$imageName,'.jpeg')"/>
					</xsl:when>
					<xsl:when test="java:file-exists($SVGImage)">
						<xsl:value-of select="concat('../icono/',$resolution,'/',$imageName,'.svg')"/>
					</xsl:when>
					<!--<xsl:otherwise><xsl:value-of select="$TIFImage"/></xsl:otherwise>-->
				</xsl:choose>
			</xsl:when>
			<!-- Résolution basse ou moyenne déf.-->
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="java:file-exists($PNGImage)" >
						<xsl:value-of select="concat('../icono/',$resolution,'/',$imageName,'.png')"/>
					</xsl:when>
					<xsl:when test="java:file-exists($SVGImage)" >
						<xsl:value-of select="concat('../icono/',$resolution,'/',$imageName,'.svg')"/>
					</xsl:when>
					<!-- sinon recherche de l'image en .jpg-->
					<xsl:when test="java:file-exists($JPGImage)">
						<xsl:value-of select="concat('../icono/',$resolution,'/',$imageName,'.jpg')"/>
					</xsl:when>
					<xsl:when test="java:file-exists($JPEGImage)">
						<xsl:value-of select="concat('../icono/',$resolution,'/',$imageName,'.jpeg')"/>
					</xsl:when>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>

	<!-- PATCH Langue étrangère dont chinoise -->
	<xsl:template match="*:foreign[@xml:lang]">
		<hi style="{concat('typo_lang_alt_', @xml:lang)}" aid:cstyle="{concat('typo_lang_alt_', @xml:lang)}">
			<xsl:apply-templates/>
		</hi>
	</xsl:template>
	<!-- FIN PATCH -->

	<xsl:template match="@*|node()" mode="#default">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	
	<xsl:variable name="NotesfloatingTextSys">
		<xsl:choose>
			<xsl:when test="//tei:normalization/tei:p[@rendition='floatingText'][not(@n)]">
				<xsl:value-of select="'a'"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="//tei:normalization/tei:p[@rendition='floatingText']/@n"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<xsl:variable name="NotesfloatingText">
		<xsl:value-of select="//tei:normalization/tei:p[@rendition='floatingText']/@select"/>
	</xsl:variable>
	
	<xsl:variable name="notetableSys">
		<xsl:choose>
			<xsl:when test="//tei:normalization/tei:p[@rendition='table'][not(@n)]">
				<xsl:value-of select="'a'"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="//tei:normalization/tei:p[@rendition='table']/@n"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:template match="*:hi[contains(@rend,'TEI_local')]">
		<hi>
			<xsl:variable name="localAtt" select="substring-after(@rend,'TEI_')"/>
			<xsl:attribute name="style" select="concat('typo_',$localAtt)" />
			<xsl:attribute name="aid:cstyle" select="concat('typo_',$localAtt)" />
			<xsl:apply-templates select="node()" />
		</hi>
	</xsl:template>
	
	<xsl:template match="@style">
		<xsl:choose>
			<xsl:when test="contains(.,'typo')">
				<xsl:attribute name="aid:cstyle">
					<xsl:value-of select="."/>
				</xsl:attribute>
				<xsl:attribute name="style">
					<xsl:value-of select="."/>
				</xsl:attribute>
			</xsl:when>
			
			<xsl:when test="contains(.,'surcharge')">
				<xsl:if test="parent::node()/@rend='bold'">
					<xsl:attribute name="aid:cstyle">
						<xsl:text>typo_gras</xsl:text>
					</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="style">
					<xsl:value-of select="."/>
				</xsl:attribute>
				<xsl:attribute name="style">
					<xsl:value-of select="."/>
				</xsl:attribute>
			</xsl:when>
			
			<xsl:otherwise>
				
				<xsl:variable name="in">
					<xsl:value-of select="pddn:isInFirstParasAfterFT(..)"/>
				</xsl:variable>
				<xsl:if test="$in='true'">
					<xsl:attribute name="fenc">true</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="aid:pstyle">
					<xsl:value-of select="."/>
				</xsl:attribute>
				<xsl:attribute name="style">
					<xsl:value-of select="."/>
				</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="tei:div[@type='chapitre']/tei:p[1]">
		<p aid:pstyle="premierPara">
			<xsl:apply-templates/>
		</p>
	</xsl:template>

	<xsl:template match="tei:div[@type='sponsor']/tei:p">
		<p aid:pstyle="txt_Sponsor">
			<xsl:apply-templates/>
		</p>
	</xsl:template>

	<xsl:template match="tei:speaker">
		<p aid:pstyle="txt_loc">
			<xsl:apply-templates/>
		</p>
	</xsl:template>

	<xsl:template match="tei:name[@type='speaker']">
		<hi aid:cstyle="typo_loc">
			<xsl:apply-templates/>
		</hi>
	</xsl:template>

	<xsl:template match="tei:div[@type='section1'][1][not(preceding-sibling::*)]/tei:head[@style='T_1'][1]">
		<head aid:pstyle="T_a_premier">
			<xsl:apply-templates/>
		</head>
	</xsl:template>

	<xsl:template match="tei:div[@type='annexe'][1]/tei:head[@style='T_'][1]"><xsl:text>
</xsl:text>
		<head aid:pstyle="T_a_annexe">
			<xsl:apply-templates/>
		</head>
	</xsl:template>
	
	<xsl:template match="tei:graphic">
		<graphic><xsl:attribute name="url"><xsl:value-of select="pddn:getResolutionImagePath(@url)"/></xsl:attribute></graphic>
	</xsl:template>
	
	<xsl:template match="tei:figure[tei:graphic[preceding-sibling::tei:table]]" mode="pass1">
		<xsl:copy-of select="./tei:table"/>
	</xsl:template>

	<xsl:template match="tei:figure[child::*:figure]">
		<head aid:pstyle="T_planche">
			<xsl:apply-templates select="*:head/node()"/>
		</head>
		<xsl:apply-templates select="*:figure"/>
	</xsl:template>
	
	<xsl:template match="tei:table">
		<xsl:choose>
			<xsl:when test="child::tei:head">
				<xsl:choose>
					<xsl:when test="$table='true' and descendant::tei:note[not(parent::tei:head)]">
						<ab rendition="tableau-donnees">
							<anchor type="link" id="{@xml:id}"/>
							<head aid:pstyle="titre_Tableau">
								<xsl:apply-templates select="descendant::tei:head/node()"/>
							</head>
							<table>
								<xsl:attribute name="aid:table"><xsl:text>table</xsl:text></xsl:attribute>
								<xsl:attribute name="aid:tcols"><xsl:value-of select="@cols|@aid:tcols"/></xsl:attribute>
								<xsl:variable name="nbOfRows" select="@rows|@aid:trows"/>
								<xsl:attribute name="aid:trows"><xsl:value-of select="$nbOfRows + 1"/></xsl:attribute>
								<xsl:apply-templates select="descendant::tei:row"/>
								<xsl:if test="$notesTables='notesInTables'">
									<row>
										<xsl:element name="Cellule">
											<xsl:attribute name="aid:table"><xsl:text>cell</xsl:text></xsl:attribute>
											<xsl:attribute name="aid5:cellstyle">
												<xsl:text>cellule-note</xsl:text>
											</xsl:attribute>
											<xsl:attribute name="aid:pstyle"><xsl:text>note_tableau</xsl:text></xsl:attribute>
											<xsl:attribute name="aid:crows">1</xsl:attribute>
											<xsl:attribute name="aid:ccols"><xsl:value-of select="@cols|@aid:tcols"/></xsl:attribute>
											
											<xsl:for-each select="descendant::tei:note[parent::tei:cell]|descendant::tei:note[ancestor::tei:cell]">
												<xsl:variable name="numNote"><xsl:number count="tei:note[ancestor::tei:cell]" from="tei:table" level="any" format="{$notetableSys}"/></xsl:variable>
												<hi aid:cstyle="typo_note_tableau"><xsl:value-of select="$numNote"/></hi>. <xsl:copy-of select="./node()"/><xsl:if test="not(position()=last())"><xsl:text> | </xsl:text></xsl:if>
											</xsl:for-each>
										</xsl:element>
									</row>
								</xsl:if>                                              
							</table>
						</ab>
					</xsl:when>
					
					<xsl:when test="$table='true'">
						<ab rendition="tableau-donnees">
							<anchor type="link" id="{@xml:id}"/>
							<head aid:pstyle="titre_Tableau">
								<xsl:apply-templates select="descendant::tei:head/node()"/>
							</head>
							<table>
								<xsl:attribute name="aid:table"><xsl:text>table</xsl:text></xsl:attribute>
								<xsl:attribute name="aid:tcols"><xsl:value-of select="@cols|@aid:tcols"/></xsl:attribute>
								<xsl:attribute name="aid:trows"><xsl:value-of select="@rows|@aid:rows"/></xsl:attribute>
								<xsl:apply-templates select="descendant::tei:row"/>
							</table>
						</ab>
					</xsl:when>
					
					<xsl:when test="$table='false' and descendant::tei:note">
						<ab rendition="tableau-donnees">
							<anchor type="link" id="{@xml:id}"/>
							<table>
								<xsl:attribute name="aid:table"><xsl:text>table</xsl:text></xsl:attribute>
								<xsl:attribute name="aid:tcols"><xsl:value-of select="@cols|@aid:tcols"/></xsl:attribute>
								<xsl:variable name="nbOfRows" select="@rows|@aid:trows"/>
								<xsl:attribute name="aid:trows"><xsl:value-of select="$nbOfRows + 1"/></xsl:attribute>
								<xsl:apply-templates select="descendant::tei:row"/>
								<xsl:if test="$notesTables='notesInTables'">
									<row>
										<xsl:element name="Cellule">
											<xsl:attribute name="aid:table"><xsl:text>cell</xsl:text></xsl:attribute>
											<xsl:attribute name="aid5:cellstyle">
												<xsl:text>cellule-note</xsl:text>
											</xsl:attribute>
											<xsl:attribute name="aid:pstyle"><xsl:text>note_tableau</xsl:text></xsl:attribute>
											<xsl:attribute name="aid:crows">1</xsl:attribute>
											<xsl:attribute name="aid:ccols"><xsl:value-of select="@cols|@aid:tcols"/></xsl:attribute>
											<xsl:for-each select="descendant::tei:note[parent::tei:cell]">
												<xsl:variable name="numNote"><xsl:number count="tei:note[parent::tei:cell]" from="tei:table" level="any" format="{$notetableSys}"/></xsl:variable>
												<hi aid:cstyle="typo_note_tableau"><xsl:value-of select="$numNote"/></hi>. <xsl:copy-of select="./node()"/><xsl:if test="not(position()=last())"><xsl:text> | </xsl:text></xsl:if>
											</xsl:for-each>
										</xsl:element>
									</row>
								</xsl:if>
							</table>
							<head aid:pstyle="titre_Tableau">
								<xsl:apply-templates select="descendant::tei:head/node()"/>
							</head>
						</ab>
					</xsl:when>
					
					<xsl:when test="$table='false'">
						<ab rendition="tableau-donnees">
							<anchor type="link" id="{@xml:id}"/>
							<table>
								<xsl:attribute name="aid:table"><xsl:text>table</xsl:text></xsl:attribute>
								<xsl:attribute name="aid:tcols"><xsl:value-of select="@cols|@aid:tcols"/></xsl:attribute>
								<xsl:attribute name="aid:trows"><xsl:value-of select="@rows|@aid:trows"/></xsl:attribute>
								<xsl:apply-templates select="descendant::tei:row"/>
							</table>
							<head aid:pstyle="titre_Tableau">
								<xsl:apply-templates select="descendant::tei:head/node()"/>
							</head>
						</ab>
					</xsl:when>
					<xsl:otherwise>
						<table>
							<xsl:attribute name="aid:table"><xsl:text>table</xsl:text></xsl:attribute>
							<xsl:attribute name="aid:tcols"><xsl:value-of select="@cols|@aid:tcols"/></xsl:attribute>
							<xsl:attribute name="aid:trows"><xsl:value-of select="@rows|@aid:trows"/></xsl:attribute>
							<xsl:apply-templates/>
						</table>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<table>
					<xsl:attribute name="aid:table"><xsl:text>table</xsl:text></xsl:attribute>
					<xsl:attribute name="aid:tcols"><xsl:value-of select="@cols|@aid:tcols"/></xsl:attribute>
					<xsl:attribute name="aid:trows"><xsl:value-of select="@rows|@aid:trows"/></xsl:attribute>
					<xsl:apply-templates/>
					<xsl:if test="$notesTables='notesInTables'">
						<row>
							<xsl:element name="Cellule">
								<xsl:attribute name="aid:table"><xsl:text>cell</xsl:text></xsl:attribute>
								<xsl:attribute name="aid5:cellstyle">
									<xsl:text>cellule-note</xsl:text>
								</xsl:attribute>
								<xsl:attribute name="aid:pstyle"><xsl:text>note_tableau</xsl:text></xsl:attribute>
								<xsl:attribute name="aid:crows">1</xsl:attribute>
								<xsl:attribute name="aid:ccols"><xsl:value-of select="@cols|@aid:tcols"/></xsl:attribute>
								<xsl:for-each select="descendant::tei:note[parent::tei:cell]">
									<xsl:variable name="numNote"><xsl:number count="tei:note[parent::tei:cell]" from="tei:table" level="any" format="{$notetableSys}"/></xsl:variable>
									<hi aid:cstyle="typo_note_tableau"><xsl:value-of select="$numNote"/></hi>. <xsl:copy-of select="./node()"/><xsl:if test="not(position()=last())"><xsl:text> | </xsl:text></xsl:if>
								</xsl:for-each>
							</xsl:element>
						</row>
					</xsl:if>
				</table>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="tei:note[@place='foot']">
		<xsl:choose>
			<xsl:when test="ancestor::tei:figure"><xsl:text>
</xsl:text>
				<note id="{@xml:id}">
					<xsl:copy-of select="@*"/>
					<xsl:attribute name="aid:pstyle"><xsl:text>txt_Note</xsl:text></xsl:attribute>
					<xsl:apply-templates/><lb/>
				</note>
			</xsl:when>
			<xsl:when test="ancestor::tei:cell and $notesTables='notesInTables'">
				<xsl:variable name="NoteinTable"><xsl:number count="tei:note[not(parent::tei:head)]" from="tei:table" level="any" format="{$notetableSys}"/></xsl:variable>
				<hi aid:cstyle="typo_appel_note_tableau"><xsl:value-of select="$NoteinTable"/></hi>
			</xsl:when>
			
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="not(local-name(child::node()[1]) = 'p')">
						<note id="{@xml:id}">
							<xsl:copy-of select="@*"/>
							<xsl:attribute name="aid:pstyle"><xsl:text>txt_Note</xsl:text></xsl:attribute>
							<xsl:apply-templates/><lb/>
						</note>
					</xsl:when>
					<xsl:otherwise>
						<note id="{@xml:id}">
							<xsl:copy-of select="@* except @xml:id"/>
							<xsl:attribute name="aid:pstyle"><xsl:text>txt_Note</xsl:text></xsl:attribute>
							<xsl:for-each select="descendant::tei:p[parent::tei:note]">
								<xsl:apply-templates/><lb/></xsl:for-each>
						</note>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="tei:cell">
		<xsl:variable name="origRend"><xsl:value-of select="substring-after(@rendition,'#')"/></xsl:variable>
		<cell>
			<xsl:attribute name="aid:table"><xsl:text>cell</xsl:text></xsl:attribute>
			<xsl:attribute name="rend"><xsl:value-of select="$tagsDecl//tei:rendition[@xml:id = $origRend]"/><!--<xsl:text> </xsl:text>--></xsl:attribute>
			<xsl:if test="@cols">
				<xsl:attribute name="cols"><xsl:value-of select="@cols|@aid:tcols"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="@rows">
				<xsl:attribute name="rows"><xsl:value-of select="@rows|@aid:trows"/></xsl:attribute>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="parent::tei:row[@role='label']">
					<xsl:attribute name="aid:theader"></xsl:attribute>
				</xsl:when>
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates/>
		</cell>
	</xsl:template>
	
	<!-- fin tableaux -->
	
	<!-- encadrés inclus dans le flux de texte -->
	
	<xsl:template match="tei:floatingText[not(descendant::xi:include)]">
		<xsl:variable name="FloatingTextSubtype" select="@subtype"/>
		<!-- on englobe dans un anonymous bloc et on stocke le résultat dans la variable ab-->
		<xsl:variable name="ab">
			<ab>
				<xsl:attribute name="type" select="concat('enc_',$FloatingTextSubtype)"/>
				<xsl:apply-templates/>
			</ab>
		</xsl:variable>
		<!-- on lance la transformation sur l'anonymous bloc -->
		<xsl:apply-templates select="$ab"/>
	</xsl:template>

	<xsl:template match="tei:floatingText[(descendant::xi:ab)]"></xsl:template>
	
	<!--encadrés flottants-->
	<xsl:template match="xi:include[ancestor::tei:floatingText]">
		<xsl:variable name="ref" select="./@href"/>
		<xsl:variable name="FloatingTextSubtype">
			<xsl:choose>
				<xsl:when test="ancestor::tei:div[@type='annexe']">
					<xsl:value-of select="../../@type"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="../../@subtype"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- on englobe dans un anonymous bloc et on stocke le résultat dans la variable ab-->
		<xsl:variable name="ab">
			<ab>
				<xsl:attribute name="type" select="concat('enc_',$FloatingTextSubtype)"/>
				<xsl:apply-templates select="document($ref)//tei:text/*"/>
			</ab>
		</xsl:variable>
		<!-- on lance la transformation sur l'anonymous bloc -->
		<xsl:apply-templates select="$ab"/>
	</xsl:template>
	
	<xsl:template match="//tei:ab//*[@aid:pstyle]">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:variable name="style">
				<xsl:choose>
					<xsl:when test="ancestor::tei:ab/@type">
						<xsl:value-of select="ancestor::tei:ab/@type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="enc_fixe"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="aid:pstyle">
				<xsl:value-of select="concat($style,'_', @aid:pstyle)"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="//tei:ab//*[@aid:cstyle]">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:variable name="style">
				<xsl:choose>
					<xsl:when test="ancestor::tei:ab/@type">
						<xsl:value-of select="ancestor::tei:ab/@type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="enc_fixe"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="aid:cstyle">
				<xsl:value-of select="concat($style,'_', @aid:cstyle)"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="tei:ab[starts-with(@type,'enc_')]">
		<ab>
			<xsl:attribute name="type">
				<xsl:value-of select="@type"/>
			</xsl:attribute>
			<xsl:apply-templates/>
			<div type="NoteEnc">
				<xsl:choose>
					<xsl:when test="$NotesfloatingText = 'restart'">
						<xsl:for-each select="//tei:note">
							<xsl:variable name="numNoteEnc"><xsl:number count="tei:note" level="any" format="{$NotesfloatingTextSys}"/></xsl:variable>
							<p aid:pstyle="txt_Note_Encadre"><hi aid:cstyle="typo_num_note_encadre"><xsl:value-of select="$numNoteEnc"/></hi><xsl:text>.&#00009;</xsl:text><xsl:apply-templates/></p>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise/>
				</xsl:choose>
			</div>
		</ab>
	</xsl:template>


	<xsl:template match="tei:ab[starts-with(@type,'enc_')]//tei:note[$NotesfloatingText = 'restart']">
		<xsl:variable name="numNoteEnc">
			<xsl:number count="tei:note" level="any" format="{$NotesfloatingTextSys}"/>
		</xsl:variable>
		<hi aid:cstyle="typo_appel_note_encadre">
			<xsl:value-of select="$numNoteEnc"/>
		</hi>
	</xsl:template>
	
	<xsl:template match="tei:item">
		<xsl:variable name="itemLevel">
			<xsl:value-of select="substring-after(@style,'Liste_')"/>
		</xsl:variable>
		<xsl:variable name="listType">
			<xsl:value-of select="substring-after(parent::tei:list/@rendition,'#')"/>
		</xsl:variable>
				<item>
					<xsl:attribute name="aid:pstyle">
						<xsl:value-of select="concat('txt_List_',$listType,'_',$itemLevel)"/>
					</xsl:attribute>
					<xsl:apply-templates/>
				</item>
	</xsl:template>
	
	<xsl:template match="tei:list[parent::tei:item]">
		<xsl:text>
</xsl:text>
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="tei:list"><!--<xsl:text>
							</xsl:text>-->
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="tei:ref">
		<xsl:choose>
			<xsl:when test="./@type='affiliation'"/>
			<xsl:when test="./@type='bibl'">
				<ref type="link" aid:cstyle="typo_ref_biblio" style="typo_ref_biblio">
					<xsl:copy-of select="@target"/>
					<xsl:apply-templates/>
				</ref>
			</xsl:when>
			<xsl:when test="./@type='crossref'">
				<ref aid:cstyle="typo_lien_refcroisee" style="typo_lien_refcroisee">
					<xsl:copy-of select="@*"/>
					<xsl:apply-templates/>
				</ref>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="starts-with(@target, 'http')">
						<ref type="Extlink" aid:cstyle="typo_lien_internet" style="typo_lien_internet">
							<xsl:copy-of select="@*"/>
							<xsl:apply-templates/>
						</ref>
					</xsl:when>
					<xsl:when test="starts-with(@target, 'www')">
						<ref type="Extlink" aid:cstyle="typo_lien_internet" style="typo_lien_internet">
							<xsl:copy-of select="@*"/>
							<xsl:apply-templates/>
						</ref>
					</xsl:when>
					<xsl:when test="starts-with(@target, 'mailto')">
						<ref type="Extlink" aid:cstyle="typo_lien_mail" style="typo_lien_mail">
							<xsl:copy-of select="@*"/>
							<xsl:apply-templates/>
						</ref>
					</xsl:when>
					<xsl:otherwise>
						<ref type="link" aid:cstyle="typo_lien_document" style="typo_lien_document">
							<xsl:copy-of select="@*"/>
							<xsl:apply-templates/>
						</ref>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="tei:index">
		<xsl:variable name="tablesBefore">
			<xsl:value-of select="count(preceding::tei:table)"/>
		</xsl:variable>
		<index nbtables="{$tablesBefore}">
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</index>
	</xsl:template>
	
	<xsl:template match="tei:biblStruct">
		<xsl:text>
	</xsl:text>
	</xsl:template>
	
	<xsl:template match="tei:bibl[@xml:id]">
		<bibl aid:pstyle="txt_Bibliographie"><xsl:copy-of select="@*"/><anchor id="{@xml:id}"/><xsl:apply-templates/></bibl>
	</xsl:template>
	
	<xsl:template match="*:bibl[@type='sec_authority']">
		<p>
			<xsl:attribute name="aid:pstyle">txt_Auteur_section</xsl:attribute>
			<xsl:apply-templates select="descendant::*:persName/*:forename/text()"/><xsl:text> </xsl:text><xsl:apply-templates select="descendant::*:persName/*:surname/text()"/>
		</p>
	</xsl:template>
    
	
	<xsl:template match="tei:p[@style='ill-credits-sources']">
		<p aid:pstyle="txt_credits" style="txt_credits">
			<xsl:apply-templates/>
		</p>
	</xsl:template>
	
	<!-- modification des noms de styles pour les titres du volume et génération de la TDM -->
	<xsl:template match="tei:head[parent::tei:group[contains(@type,'section')] and ancestor::tei:group[@type='book']]">
		<xsl:variable name="bookTitleDepth" select="substring-after(parent::tei:group/@type,'section')"/>
		<head>
			<xsl:attribute name="aid:pstyle" select="concat('Vol_T',$bookTitleDepth)"/>
			<xsl:copy-of select="@subtype"/>
			<xsl:apply-templates/>
		</head>
	</xsl:template>
	
	<xsl:template match="mml:math"/>
	<xsl:template match="tei:formula[@notation='tex']">
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="tei:formula[@notation='tex']/text()"/>
    
<!-- REF | clean crossref -->
    <xsl:template match="*:ref[@target= '']|*:ref[@target= '#']|*:ref[@target='URL']"/>

</xsl:stylesheet>
