<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
version="2.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:tei="http://www.tei-c.org/ns/1.0"
xmlns:xlink="http://www.w3.org/1999/xlink"
xmlns:xi="http://www.w3.org/2001/XInclude"
xmlns:mml="http://www.w3.org/1998/Math/MathML"
xmlns:aid="http://ns.adobe.com/AdobeInDesign/4.0/"
xmlns:aid5="http://ns.adobe.com/AdobeInDesign/5.0/"
exclude-result-prefixes="tei xsl xlink xi mml">

<xsl:output method="xml" encoding="UTF-8" indent="no" />


	<xsl:param name="output" />
	
	<!-- PSEUDO-TABLEAUX ASSOCIATIFS -->	
	<!-- les équivalences @rend -> @style pour la typo -->
	<xsl:variable name="typoRef">
		<style eq="bold">gras</style>
		<style eq="italic">Italique</style>
		<style eq="bold italic">italic_gras</style>
		<style eq="italic bold">italic_gras</style>
		<style eq="small-caps">SC</style>
		<style eq="small-caps-ital">SC_italic</style>
		<style eq="small-caps italic">SC_italic</style>
		<style eq="italic small-caps">SC_italic</style>
		<style eq="strikethrough">line-through</style>
		<style eq="sup">Exposant</style>
		<style eq="sup italic">Exposant_Italic</style>
		<style eq="italic sup">Exposant_Italic</style>
		<style eq="sub">Indice</style>
		<style eq="underline">souligne</style>
	</xsl:variable>	
	
	<!-- les affiliations (pour mettre un pointeur dans le header) -->
	<xsl:variable name="listAffiliations">
		<xsl:for-each select="distinct-values(.//*:affiliation/*:orgName)">
			<orgRef n="{position()}"><xsl:value-of select="." /></orgRef>
		</xsl:for-each>
	</xsl:variable>

	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()" />
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="*:TEI">
		<xsl:copy>
			<xsl:apply-templates select="@*" />
			<xsl:attribute name="change" select="'metopes_edition'" />
			<xsl:apply-templates select="node()" />
		</xsl:copy>
	</xsl:template>

	<!-- HEADER -->	
	<xsl:template match="*:titleStmt//*:title">
		<xsl:copy>
			<xsl:apply-templates select="@* except @type" />
			<xsl:attribute name="type" select="if(@type='trl') then('alt') else(@type)" />
			<xsl:apply-templates select="node()" />
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="*:editor">
		<xsl:copy>
			<xsl:attribute name="role" select="if(not(@role) or @role='##') then('edt') else(@role)" />
			<xsl:apply-templates select="node()" />
		</xsl:copy>
	</xsl:template>	
	
	<xsl:template match="*:titleStmt//*:persName">
		<name xmlns="http://www.tei-c.org/ns/1.0">
			<xsl:value-of select="string-join(.//text()[not(parent::*:idno)], ' ')" />
		</name>
		<xsl:apply-templates select="*:idno"/>
	</xsl:template>
	
	<xsl:template match="*:titleStmt//*:affiliation">
		<xsl:variable name="orgName" select="*:orgName" />
		<xsl:variable name="orgRef">
			<xsl:if test="string-length($listAffiliations//*:orgRef[text()=$orgName]/@n) eq 1">
				<xsl:text>0</xsl:text>
			</xsl:if>
			<xsl:value-of select="$listAffiliations//*:orgRef[text()=$orgName]/@n"/>
		</xsl:variable>
		        <xsl:choose>
            <xsl:when test="child::*:ref[@type='affiliation']">
                <xsl:copy-of select="."/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <ref xmlns="http://www.tei-c.org/ns/1.0" type="affiliation">
                        <xsl:attribute name="target">
                            <xsl:value-of select="concat('#aff',$orgRef)" />
                        </xsl:attribute>
                    </ref>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>	
	
	<xsl:template match="*:publicationStmt">
		<publicationStmt xmlns="http://www.tei-c.org/ns/1.0">
            <publisher><xsl:value-of select="*:ab[@type='expression']/*:bibl/*:publisher"/></publisher>
            <pubPlace><xsl:value-of select="*:ab[@type='expression']/*:bibl/*:pubPlace"/></pubPlace>
            <availability>
                <licence rend="##"><xsl:value-of select="*:ab[@type='expression']/*:bibl/*:availability/*:licence"/></licence>
                <xsl:for-each select="*:ab[@type='expression']/*:bibl/*:availability/*:p">
                    <licence rend="##"><xsl:value-of select="."/></licence>
                </xsl:for-each>
            </availability>
            <xsl:copy-of select="*:ab[@type='editorial_workflow']"/>
            <ab type="papier">
                <idno type="ISBN-10"></idno>
                <idno type="ISBN-13"><xsl:value-of select="*:ab[@type='book']//*:idno[@type='ISBN-13']"/></idno>
                <idno type="ISSN"><xsl:value-of select="*:ab[@type='book']//*:idno[@type='ISSN']"/></idno>
                <desc type="licencediff"></desc>
                <desc type="licencerepro"></desc>
                <desc type="licence"><xsl:value-of select="*:ab[@type='book']//*:availability/*:licence/@target"/></desc>
                <date type="publication">
                    <xsl:value-of select="substring(*:ab[@type='book']//*:date[@type='publishing']/@when,9,2)"/><xsl:text>/</xsl:text>
                    <xsl:value-of select="substring(*:ab[@type='book']//*:date[@type='publishing']/@when,6,2)"/>
                    <xsl:text>/</xsl:text>
                    <xsl:value-of select="substring(*:ab[@type='book']//*:date[@type='publishing']/@when,1,4)"/>
                </date>
                <dimensions>
                    <dim type="pagination">
                        <xsl:if test="*:ab[@type='book']//*:biblScope[@unit='page'][@from!='']">
                            <xsl:value-of select="*:ab[@type='book']//*:biblScope[@unit='page']/@from"/><xsl:text>-</xsl:text><xsl:value-of select="*:ab[@type='book']//*:biblScope[@unit='page']/@to"/>
                        </xsl:if>
                    </dim>
                </dimensions>
            </ab>
            <ab type="pdf">
                <idno type="DOI"><xsl:value-of select="*:ab[@subtype='PDF']//*:idno[@type='DOI']"/></idno>
                <desc type="licence"><xsl:value-of select="*:ab[@subtype='PDF']//*:availability/*:licence/@target"/></desc>
                <date>
                    <xsl:value-of select="substring(*:ab[@subtype='PDF']//*:date[@type='publishing']/@when,9,2)"/><xsl:text>/</xsl:text>
                    <xsl:value-of select="substring(*:ab[@subtype='PDF']//*:date[@type='publishing']/@when,6,2)"/>
                    <xsl:text>/</xsl:text>
                    <xsl:value-of select="substring(*:ab[@subtype='PDF']//*:date[@type='publishing']/@when,1,4)"/>
                </date>
                <dimensions>
                    <dim type="weight"><xsl:value-of select="*:ab[@subtype='PDF']//*:dim[@type='weight']/@extent"/></dim>
                </dimensions>
                <name type="diffuseur">
                    <xsl:value-of select="*:ab[@subtype='PDF']//*:distributor"/>
                </name>
                <xsl:copy-of select="*:ab[@subtype='PDF']//*:bibl/*:ref[@type='site']"/>
            </ab>
            <ab type="epub">
                <idno type="ISBN-10"></idno>
                <idno type="ISBN-13"><xsl:value-of select="*:ab[@subtype='EPUB']//*:idno[@type='ISBN-13']"/></idno>
                <idno type="EAN"></idno>
                <idno type="DOI"><xsl:value-of select="*:ab[@subtype='EPUB']//*:idno[@type='DOI']"/></idno>
                <desc type="licence"><xsl:value-of select="*:ab[@subtype='EPUB']//*:availability/*:licence/@target"/></desc>
                <date>
                    <xsl:value-of select="substring(*:ab[@subtype='EPUB']//*:date[@type='publishing']/@when,9,2)"/><xsl:text>/</xsl:text>
                    <xsl:value-of select="substring(*:ab[@subtype='EPUB']//*:date[@type='publishing']/@when,6,2)"/>
                    <xsl:text>/</xsl:text>
                    <xsl:value-of select="substring(*:ab[@subtype='EPUB']//*:date[@type='publishing']/@when,1,4)"/>
                </date>
                <xsl:copy-of select="*:ab[@subtype='EPUB']//*:desc"/>
                <name type="diffuseur">
                    <xsl:value-of select="*:ab[@subtype='EPUB']//*:name[@type='sales-agent']"/>
                </name>
                <xsl:copy-of select="*:ab[@subtype='EPUB']//*:bibl/*:ref[@type='site']"/>
            </ab>
            <xsl:for-each select="*:ab[@subtype='HTML']">
                <ab type="site">
                    <xsl:attribute name="type" select="
						if(descendant::*:distributor='OpenEdition')
							then('lodel')
						else if(descendant::*:distributor='Cairn.info') 
							then('cairn')
						else('site')"/>
                    <idno type="DOI"><xsl:value-of select="descendant::*:idno[@type='DOI']"/></idno>
                    <idno type="ISBN-13"><xsl:value-of select="descendant::*:idno[@type='ISBN-13']"/></idno>
                    <desc type="licence"><xsl:value-of select="descendant::*:availability/*:licence/@target"/></desc>
                    <date type="public">
                        <xsl:value-of select="substring(descendant::*:date[@type='publishing']/@when,9,2)"/><xsl:text>/</xsl:text>
                        <xsl:value-of select="substring(descendant::*:date[@type='publishing']/@when,6,2)"/>
                        <xsl:text>/</xsl:text>
                        <xsl:value-of select="substring(descendant::*:date[@type='publishing']/@when,1,4)"/>
                    </date>
                    <desc type="site"></desc>
                    <xsl:copy-of select="descendant::*:bibl/*:ref[@type='site']"/>
                </ab>
            </xsl:for-each>
<!--
            <availability xmlns="http://www.tei-c.org/ns/1.0">
                <xsl:for-each select="*:ab[@type='expression']/*:bibl/*:availability/*:p">
                    <licence rend="##"><xsl:apply-templates/></licence>
                </xsl:for-each>
            </availability>
			<xsl:for-each select="*:ab[not(@type='expression') and not(@type='editorial_workflow')]">
				<ab>
					<xsl:attribute name="type" select="
						if(@type='book')
							then('papier')
						else if(@subtype='HTML') 
							then('lodel')
						else if(@subtype='PDF')
							then('pdf')
						else if(@subtype='EPUB')
							then('epub')
						else('')" />							
					<xsl:apply-templates select="*:bibl/element()" />
				</ab>
			</xsl:for-each>			
-->
            <xsl:if test="child::*:ab[@subtype='archeo']">
				<ab type="archeo">
					<xsl:copy-of select="child::*:ab[@subtype='archeo']/*:idno"/>
					<xsl:copy-of select="child::*:ab[@subtype='archeo']/*:date"/>
					<term type="nature_op"><xsl:copy-of select="child::*:ab[@subtype='archeo']//*:term/node()"/></term>
				</ab>
			</xsl:if>	
            <xsl:if test="child::*:ab[@type='CUP']">
                <xsl:copy-of select="child::*:ab[@type='CUP']"/>
            </xsl:if>
			<idno type="book"><xsl:value-of select="*:ref[@type='volume_xml']/@target" /></idno>
		</publicationStmt>
	</xsl:template>
	
	<!--
	<xsl:template match="*:publicationStmt//*:date">
		<xsl:copy>
			<xsl:attribute name="when" select="@date" />
			<xsl:apply-templates select="@type|node()" />
		</xsl:copy>
	</xsl:template>
	-->
	
	<xsl:template match="*:publicationStmt//*:dim">
		<dimensions xmlns="http://www.tei-c.org/ns/1.0">
			<xsl:copy>
				<xsl:apply-templates select="@*|node()" />
			</xsl:copy>	
		</dimensions>
	</xsl:template>	
	
	<xsl:template match="*:publicationStmt//*:idno">
		<xsl:copy>
			<xsl:if test="@type='DOI'">
				<xsl:attribute name="type" select="'DOI'" />
			</xsl:if>
			<xsl:apply-templates select="node()" />
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="*:publicationStmt//*:ref">
		<idno xmlns="http://www.tei-c.org/ns/1.0" type="URL">
			<xsl:value-of select="@target" />
		</idno>
	</xsl:template>
	
	<xsl:template match="*:publicationStmt//*:availability">
		<xsl:copy>
			<xsl:apply-templates select="*:licence/*:p/node()" />
		</xsl:copy>
	</xsl:template>	
	
	<xsl:template match="*:appInfo">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()" />
			<application xmlns="http://www.tei-c.org/ns/1.0" ident="commons_2_metopes" version="1.0">
   				<label>Conversion Commons vers Métopes v3</label>
   				<desc>XSL commons_2_metopes</desc>
			</application>
		</xsl:copy>
	</xsl:template>
    
    <xsl:template match="*:listChange">
	<xsl:variable name="currentMonth" select="
			if(string-length(string(month-from-date(current-date()))) eq 1)
				then(concat('0', month-from-date(current-date())))
			else(month-from-date(current-date()))"/>
		<xsl:variable name="currentDay" select="
			if(string-length(string(day-from-date(current-date()))) eq 1)
				then(concat('0', day-from-date(current-date())))
			else(day-from-date(current-date()))"/>
               <change xmlns="http://www.tei-c.org/ns/1.0" type="creation" when="{concat(year-from-date(current-date()), '-', $currentMonth, '-', $currentDay)}">Conversion Commons vers Métopes v3</change>
        <xsl:apply-templates/>
    </xsl:template>
	
	<!-- FRONT -->
	<xsl:template match="*:front">
		<xsl:copy>
			<xsl:if test="child::*:div[@type='titlePage_PAO']">
				<titlePage xmlns="http://www.tei-c.org/ns/1.0" type="pagedetitre" xml:id="pdt1">
					<xsl:for-each select="child::*:div[@type='titlePage_PAO']/*:p">
						<p xmlns="http://www.tei-c.org/ns/1.0" aid:pstyle="{@rend}"><xsl:apply-templates select="."/></p>
					</xsl:for-each>
					<xsl:for-each select="child::*:div[@type='dedication']/*:p">
						<p style="Vol_dedicace"><xsl:apply-templates select="node()" /></p>
					</xsl:for-each>
					<xsl:for-each select="child::*:div[@type='introduction']/*:p">
						<p style="Vol_txt_liminaire"><xsl:apply-templates select="node()" /></p>
					</xsl:for-each>
					<xsl:for-each select="child::*:div[@type='epigraph']//*:quote">
						<p style="Vol_epigraph"><xsl:apply-templates select="node()" /></p>
					</xsl:for-each>
					<xsl:for-each select="child::*:div[@type='ack']/*:p">
						<p style="Vol_remerciements"><xsl:apply-templates select="node()" /></p>
					</xsl:for-each>
            </titlePage>
            </xsl:if>
			<xsl:apply-templates select="*:titlePage[@type='pagedetitre']" />
			<xsl:apply-templates select="*:div[@type='titlePage']" />
			<xsl:if test="*:div[@type='abstract'] or *:div[@type='keywords']">	
				<xsl:call-template name="resume_motscles" />
			</xsl:if>
			<xsl:apply-templates select="*:note" />
			<xsl:apply-templates select="*:argument" />
			<xsl:apply-templates select="*:div[@type='archeo']" />
			<xsl:apply-templates select="*:div[@type='inst-partner']" />
            <xsl:apply-templates select="*:div[@type='funder']" />
			<xsl:if test="*:div[@type='data' or @type='publication' or @type='external_data']">
				<div xmlns="http://www.tei-c.org/ns/1.0" type="data">
					<xsl:if test="*:div[@type='data']">
						<xsl:for-each select="*:div[@type='data']/*:p">
							<p style="lien_donnees"><xsl:apply-templates select="node()" /></p>
						</xsl:for-each>
					</xsl:if>
					<xsl:if test="*:div[@type='publication']">
						<xsl:for-each select="*:div[@type='publication']/*:p">
							<p style="lien_publications"><xsl:apply-templates select="node()" /></p>
													</xsl:for-each>					
					</xsl:if>
                    <xsl:if test="*:div[@type='external_data']">
						<xsl:for-each select="*:div[@type='external_data']//*:bibl|*:div[@type='external_data']//*:p">
                            <p>
                                <xsl:attribute name="style">
                                    <xsl:choose>
                                        <xsl:when test="ancestor::*:floatingText[@type='linked_publications']">lien_publications</xsl:when>
                                        <xsl:otherwise>lien_donnees</xsl:otherwise>
                                    </xsl:choose>
                                </xsl:attribute>
                                <xsl:apply-templates select="node()"/>
                            </p>
                        </xsl:for-each>
					</xsl:if>
				</div>	
			</xsl:if>
			<xsl:if test="*:div[@type='ack' or @type='dedication'] or *:epigraph">
				<div xmlns="http://www.tei-c.org/ns/1.0" type="prelim">
					<xsl:apply-templates select="*:epigraph" />
					<xsl:if test="*:div[@type='dedication']">
						<xsl:for-each select="*:div[@type='dedication']/*:p">
							<p style="txt_dedicace"><xsl:apply-templates select="node()" /></p>
						</xsl:for-each>
					</xsl:if>
					<xsl:if test="*:div[@type='ack']">
						<xsl:for-each select="*:div[@type='ack']/*:p">
							<p style="txt_remerciements"><xsl:apply-templates select="node()" /></p>
						</xsl:for-each>					
					</xsl:if>
				</div>	
			</xsl:if>
		</xsl:copy>
	</xsl:template>

	<!-- FRONT: titlePage et titlePart -->
	<xsl:template match="*:div[@type='titlePage']">
		<titlePage xmlns="http://www.tei-c.org/ns/1.0">
			<docTitle>
				<xsl:apply-templates select="*:p[starts-with(@rend, 'title')]" />
			</docTitle>
			<xsl:apply-templates select="*:p[not(starts-with(@rend, 'title'))]" />
		</titlePage>
	</xsl:template>
	
	<xsl:template match="*:div[@type='titlePage']/*:p[starts-with(@rend, 'title')]">
		<xsl:variable name="type" select="substring-after(@rend, '-')" />
		<titlePart xmlns="http://www.tei-c.org/ns/1.0">
			<!-- TODO: j’ai possiblement un attribut @style vide : WAD ? -->
			<xsl:attribute name="style" select="
				if($type='sup') 
					then('T_Surtitre')
				else if($type='main')
					then('T_3_Article')
				else if($type='sub')
					then('T_SousTitre')
				else if($type='trl')
					then('T_0_Article_UK')
				else('')" />
			<xsl:attribute name="type" select="if($type='trl') then('alt') else($type)" />
			<xsl:apply-templates select="@* except @rend|node()" />
		</titlePart>
	</xsl:template>

	<!-- TODO: c’est bien toujours "author-aut" ? Jamais "author-XXX" ?-->
	<xsl:template match="*:div[@type='titlePage']/*:p[@rend='author-aut']">
		<docAuthor style="txt_auteur" xmlns="http://www.tei-c.org/ns/1.0">
			<xsl:apply-templates select="node()" />
		</docAuthor>
	</xsl:template>	
	
	<xsl:template match="*:div[@type='titlePage']/*:p[not(starts-with(@rend, 'title')) and not(@rend='author-aut')]">
		<xsl:choose>
			<xsl:when test="@rend='authority_affiliation'">
				<byline style="auteur_Institution" xmlns="http://www.tei-c.org/ns/1.0">
					<affiliation xml:id="{concat('aff0',count(preceding-sibling::*:p[@rend='authority_affiliation'])+1)}">
						<xsl:apply-templates select="node()" />
					</affiliation>
				</byline>			
			</xsl:when>
			<xsl:when test="@rend='authority_mail'">
				<byline style="auteur_Courriel" xmlns="http://www.tei-c.org/ns/1.0">
					<email>
						<xsl:choose>
							<xsl:when test="*:ref">
								<xsl:apply-templates select="*:ref" />
							</xsl:when>
							<xsl:otherwise>
								<ref target="mailto:{text()}">
									<xsl:apply-templates select="node()" />
								</ref>								
							</xsl:otherwise>
						</xsl:choose>
					</email>
				</byline>			
			</xsl:when>
			<xsl:when test="starts-with(@rend, 'editor')">
				<byline style="txt_collaborateur" xmlns="http://www.tei-c.org/ns/1.0">
					<xsl:apply-templates select="node()" />
				</byline>
			</xsl:when>
            <xsl:when test="starts-with(@rend, 'authorities')">
                <byline style="txt_auteurs" xmlns="http://www.tei-c.org/ns/1.0">
                    <xsl:apply-templates select="node()" />
                </byline>
            </xsl:when>
		</xsl:choose>
	</xsl:template>	

	<!-- FRONT: résumé et mots-clés -->
	<!-- vérifier que c’est nécessaire avec un front complet -->
	<xsl:template name="resume_motscles">
		<xsl:variable name="mainLang" select="substring-before(//*:langUsage/*:language/@ident, '-')" />
		<div xmlns="http://www.tei-c.org/ns/1.0" type="resume_motscles">
			<xsl:for-each select="//*:div[@type='abstract' or @type='keywords']/*:p">
				<xsl:variable name="style">
					<xsl:value-of select="if(parent::*:div/@type='abstract') then('txt_Resume') else('txt_Motclef')"/><xsl:value-of select="if(parent::*:div/@xml:lang=$mainLang) then('') else('_italique')" />
				</xsl:variable>
				<p style="{$style}" xml:lang="{parent::*:div/@xml:lang}">
					<xsl:apply-templates select="node()" />
				</p>
			</xsl:for-each>
		</div>
	</xsl:template>
	
	<!-- FRONT: chapô-->
	<xsl:template match="*:argument">
		<xsl:copy>
			<xsl:for-each select="*:p">
				<p xmlns="http://www.tei-c.org/ns/1.0" style="txt_chapo">
					<xsl:apply-templates select="node()" />
				</p>
			</xsl:for-each>
		</xsl:copy>
	</xsl:template>

	<!-- FRONT: partenaires - funder -->
	<xsl:template match="*:div[@type='inst-partner']|*:div[@type='funder']">
		<div xmlns="http://www.tei-c.org/ns/1.0" type="partenaires">
			<xsl:for-each select="*:p">
				<p style="org_part">
					<xsl:apply-templates select="node()" />
				</p>
			</xsl:for-each>
		</div>
	</xsl:template>

	
	<!-- BODY -->	
	<xsl:template match="*:text/*:body">
		<xsl:copy>
			<div type="chapitre" xml:id="mainDiv" xmlns="http://www.tei-c.org/ns/1.0">
                <xsl:choose>
                    <xsl:when test="ancestor::*:text[@type='review']|ancestor::*:text[@type='commentary']|ancestor::*:text[@type='feature']"> 
                        <xsl:choose>
                            <xsl:when test="*:div[@type='review']">
                                <xsl:for-each select="*:div[@type='review']">
                                    <div type="recension">
<!--                                        <xsl:apply-templates select="./descendant::*:bibl[not(@type='sec_authority')]"/>-->
                                        <xsl:apply-templates />
                                    </div>
                                </xsl:for-each>
                            </xsl:when>
                            <xsl:otherwise>
                                <div type="recension">
<!--                                    <xsl:apply-templates select="ancestor::*:text//*:bibl"/>-->
                                    <xsl:apply-templates />
                                </div>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates />
                    </xsl:otherwise>
                </xsl:choose>
			</div>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="*:div/*:head">
		<xsl:variable name="level" select="substring-after(parent::*:div/@type, 'section')" />
		<xsl:copy>
			<xsl:attribute name="style" select="concat('T_',$level)" />
			<xsl:attribute name="subtype" select="concat('level',$level)" />
			<xsl:apply-templates select="node()" />
		</xsl:copy>
	</xsl:template>
    
<!--  GROUP (VOL)  -->
    
    <xsl:template match="*:text[@xml:id='book']/*:group[@type='book']//*:head">
        <xsl:variable name="level" select="substring-after(parent::*:group/@type, 'section')" />
        <xsl:copy>
			<xsl:attribute name="style" select="concat('T_',$level)" />
			<xsl:attribute name="subtype" select="concat('level',$level)" />
			<xsl:apply-templates select="node()" />
		</xsl:copy>
    </xsl:template>


	<!-- PARAGRAPHES, LISTES ET ENCADRÉS-->
	<!-- TODO: peut-être faire 3 templates : div/p, note/p et figure/p
		Les note/p n’ont jamais d’attributs 
		Vérifier solidité du test pour le code en block	
	-->
<xsl:template match="*:body//*:p[not(starts-with(@rend, 'archeo'))]|*:back//*:p">
		<xsl:copy>
			<xsl:if test="not(parent::*:note) and not(child::*:code[not(@rend='inline')])">
			<xsl:variable name="local" select="substring-after(@rend,'TEI_local')"/>
				<xsl:attribute name="style" select="
					if(@rend='break') 
						then('txt_separateur')
					else if(@rend='caption')
						then('txt_Legende')
					else if(starts-with(@rend,'TEI_local'))
						then(concat('adlocal',$local))
					else if(@rend='signature')
						then('txt_Signature')
					else if(@rend='consecutive')
						then('txt_Normal_suite')
					else if(@rend='credits' and preceding-sibling::*:graphic or following-sibling::*:graphic)
						then('ill-credits-sources')
					else if(@rend='credits' and preceding-sibling::*:table or following-sibling::*:table)
						then('table-credits-sources')
					else if(not(@rend) and ancestor::*:cell)
						then('texte-tab')
					else if(@rend='#rtl')
						then('txt_Normal_inv')
					else('txt_Normal')" />
			</xsl:if>
			<xsl:if test="@rend='break'">
				<xsl:attribute name="rend" select="'break'" />
			</xsl:if>
			<xsl:if test="@rend='#rtl'">
				<xsl:attribute name="rend" select="'rtl'" />
			</xsl:if>
			<xsl:apply-templates select="node()" />
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="*:body//*:list/*:item">
		<xsl:copy>
			<xsl:attribute name="style" select="concat('txt_Liste_',count(ancestor::*:list))"/>
			<xsl:apply-templates select="@*|node()" />
		</xsl:copy>
	</xsl:template>


	<!-- TODO: @n nécessaire ? Correspond à l’ordre ou à un label ?
			La structure COMMONS est-elle bien floatingText/body/head ou floatingText/body/div/head ?
	-->
	
	<xsl:template match="*:floatingText">
		<xsl:choose>
			<xsl:when test="descendant::*:include">
				<xsl:for-each select="descendant::*:include">
					<floatingText type="encadre">
					<xsl:attribute name="subtype" select="if(contains(@type,'')) then('fixe') else(@type)"/>
						<group>
							<xsl:variable name="ref" select="./@href"/>
							<xsl:variable name="ab">
								<ab>
									<xsl:attribute name="type" select="'enc_encadre'"/>
									<xsl:copy-of select="document($ref)//tei:front/*"/>
									<xsl:apply-templates select="document($ref)//tei:text/*"/>
								</ab>
							</xsl:variable>
							<xsl:apply-templates select="$ab"/>
						</group>
					</floatingText>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<floatingText xmlns="http://www.tei-c.org/ns/1.0" type="encadre" subtype="{@type}">
					<xsl:apply-templates select="node()" />
				</floatingText>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="*:floatingText/*:body">
		<xsl:copy>
			<div xmlns="http://www.tei-c.org/ns/1.0" type="encadre">
				<xsl:apply-templates select="node()" />
			</div>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="*:floatingText/*:body/*:head">
		<head style="{concat('titreEnc',ancestor::*:floatingText/@type)}"  xmlns="http://www.tei-c.org/ns/1.0">
			<xsl:apply-templates select="node()" />
		</head>
	</xsl:template>

	<xsl:template match="*:cit">
        <xsl:choose>
            <xsl:when test="@type='linguistic'">
                <xsl:copy-of select="."/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="node()" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

	<!-- TODO
		@style = txt_Epigraphe | txt_Citation | txt_Citation_italique
		@rend = quotation | quotation italique		> seulement pour les blocks
			> que faire de quotation2 ? > à garder
		@xml:lang = reprendre si présent ? > oui
		Est-ce bien la présence ou non d’@xml:lang qui "déclenche" l’italique ? > oui
		Si oui, style "txt_Epigraphe_italique" ? > non
		distinction "txt_Citation" (block) vs "typo_Citation" (inline)	> se baser sur la présence d’un parent p
	-->
	<xsl:template match="*:quote">		
		<xsl:copy>
			<xsl:if test="not(ancestor::*:epigraph)">
				<xsl:attribute name="rend" select="if(@xml:lang) then('quotation italique') else('quotation')" />
			</xsl:if>
				<xsl:attribute name="style" select="if(ancestor::*:epigraph) then('txt_Epigraphe') else if(@type='trl') then('txt_Citation_traduction') else if(@xml:lang) then('txt_Citation_italique') else if(@type='quotation2') then('txt_Citation2') else('txt_Citation')" />
			<xsl:if test="@xml:lang">
				<xsl:attribute name="xml:lang" select="@xml:lang" />
			</xsl:if>
			<!-- remplacé par un élément <gloss> dans COMMONS ? -->
			<xsl:if test="@type='gloss'">
				<xsl:attribute name="type" select="'glose'" />
			</xsl:if>
			<xsl:if test="ancestor::*:p">
				<xsl:attribute name="style" select="'typo_Citation'" />
			</xsl:if>
			<xsl:if test="parent::*:cit[parent::*:cit]">
				<xsl:attribute name="style" select="'txt_Citation_imbriquee'" />
			</xsl:if>
			<xsl:apply-templates select="node()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="*:bibl[ancestor::*:cit]">
	<xsl:choose>
		<xsl:when test="@rend='inline'">
			<bibl style="typo_Sources">
				<xsl:apply-templates select="node()" />
			</bibl>
		</xsl:when>
		<xsl:otherwise>
			<bibl style="txt_Sources">
				<xsl:apply-templates select="node()" />
			</bibl>
		</xsl:otherwise>
	</xsl:choose>
	</xsl:template>
	
	<!-- POÉSIE -->
	
    <xsl:template match="*:lg[not(ancestor::*:cit)]">
        <xsl:variable name="lang" select="@xml:lang"/>
        <xsl:copy>
            <xsl:attribute name="style">
                <xsl:choose>
                    <xsl:when test="local-name(following-sibling::*[1]) != 'lg' and local-name(preceding-sibling::*[1]) != 'lg'">
                        <xsl:text>txt_strophe</xsl:text><xsl:if test="$lang!=''">_<xsl:value-of select="$lang"/></xsl:if>
                    </xsl:when>
                    <xsl:when test="local-name(preceding-sibling::*[1]) != 'lg'">
                        <xsl:text>txt_strophe_debut</xsl:text><xsl:if test="$lang!=''">_<xsl:value-of select="$lang"/></xsl:if>
                    </xsl:when>
                    <xsl:when test="local-name(following-sibling::*[1]) != 'lg'">
                        <xsl:text>txt_strophe_fin</xsl:text><xsl:if test="$lang!=''">_<xsl:value-of select="$lang"/></xsl:if>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>txt_strophe_suite</xsl:text><xsl:if test="$lang!=''">_<xsl:value-of select="$lang"/></xsl:if>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
			<xsl:apply-templates select="@*|node()" />
		</xsl:copy>
    </xsl:template>
    
	<xsl:template match="*:lg[ancestor::*:cit]">
        <xsl:variable name="lang" select="@xml:lang"/>
		<xsl:copy>
            <xsl:attribute name="style">
                <xsl:choose>
                    <xsl:when test="count(child::*:l) = 1">
                        <xsl:text>txt_vers</xsl:text><xsl:if test="$lang!=''">_<xsl:value-of select="$lang"/></xsl:if>
                    </xsl:when>
                    <xsl:when test="local-name(following-sibling::*[1]) != 'lg' and local-name(preceding-sibling::*[1]) != 'lg'">
                        <xsl:text>txt_strophe</xsl:text><xsl:if test="$lang!=''">_<xsl:value-of select="$lang"/></xsl:if>
                    </xsl:when>
                    <xsl:when test="position() = 1">
                        <xsl:text>txt_strophe_debut</xsl:text><xsl:if test="$lang!=''">_<xsl:value-of select="$lang"/></xsl:if>
                    </xsl:when>
                    <xsl:when test="position() = last()">
                        <xsl:text>txt_strophe_fin</xsl:text><xsl:if test="$lang!=''">_<xsl:value-of select="$lang"/></xsl:if>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>txt_strophe_suite</xsl:text><xsl:if test="$lang!=''">_<xsl:value-of select="$lang"/></xsl:if>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
			<xsl:apply-templates select="@*|node()" />
		</xsl:copy>
	</xsl:template>
    
    <xsl:template match="*:l">
        <xsl:apply-templates select="node()" />
        <xsl:if test="position() != last()"><xsl:text>&#x2028;</xsl:text></xsl:if>
	</xsl:template>
	
	<!-- THÉÂTRE -->
	<!-- 
		name@type="speaker"	 -> à rebasculer dans un <speaker> en début de <sp> ?
		sp/@who="locuteur" -> "$locuteur" ?
		Je vois pas de différences sinon
	-->
	<xsl:template match="*:sp/*:speaker">
		<p>
			<xsl:attribute name="style" select="'txt_Locuteur'" />
			<xsl:apply-templates select="@*|node()" />
		</p>
	</xsl:template>

	<xsl:template match="*:sp/*:p">
		<p>
			<xsl:attribute name="style" select="'txt_Replique'" />
			<xsl:apply-templates select="@*|node()" />
		</p>
	</xsl:template>

	<xsl:template match="*:stage">
	<xsl:choose>
		<xsl:when test="@rend='inline'">
			<hi>
				<xsl:attribute name="style" select="'typo_Didascalie'" />
				<xsl:apply-templates select="@*|node()" />
			</hi>
		</xsl:when>
		<xsl:otherwise>
			<p>
				<xsl:attribute name="style" select="'txt_Didascalie'" />
				<xsl:apply-templates select="@*|node()" />
			</p>
		</xsl:otherwise>
	</xsl:choose>
		
	</xsl:template>

	<!-- LINGUISTIQUE -->
	<!-- TODO: le passage de cit à quote (avec suppression d’un niveau si je lis bien ?) devrait être réglé par le traitement standard des citations imbriquées ?
			Sinon : - @n devient <num>
					- ordre glose/réf. biblio sont inversés : WAD ? Ou ordre inimportant, toujours reproduire celui du doc 
	-->
	<xsl:template match="*:gloss">
		<quote xmlns="http://www.tei-c.org/ns/1.0" type="glose">
			<xsl:apply-templates select="node()" />
		</quote>
	</xsl:template>

	<xsl:template match="*:foreign">
		<foreign xmlns="http://www.tei-c.org/ns/1.0" xml:lang="{@xml:lang}">
			<xsl:attribute name="style" select="concat('typo_lang_',@xml:lang)"/>
			<xsl:apply-templates select="node()" />
		</foreign>
	</xsl:template>

	<!-- ENTRETIENS, CODE : encodages identiques sauf erreur…? -->
	<!-- CODE: manque @style + il est présent (mais superflu) sur le p parent -->
	<xsl:template match="*:code">
		<xsl:copy>
			<xsl:attribute name="style" select="if(@rend='inline') then('typo_Code') else('txt_Code')" />
			<xsl:apply-templates select="@*|node()" />
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="*:sp[@rend='answer' or @rend='question']/*:p">
	    <p xmlns="http://www.tei-c.org/ns/1.0">
			<xsl:attribute name="rend" select="parent::*:sp/@rend"/>
			<xsl:attribute name="style" select="
						if(parent::*:sp/@rend='answer')
							then('txt_reponse')
						else('txt_question')
					" />
				<xsl:apply-templates select="node()" />
		</p>
	</xsl:template>
	<!-- FIGURES, TABLEAUX et MATH -->
	<!-- besoin d’un template pour enlever l’attribut figure/@rend='block' ? -->

	<!-- TODO: 
		> formule dans p, cf métopes l.770
	-->
	<xsl:template match="*:figure[not(@rend='inline')][*:formula]">
		<p xmlns="http://www.tei-c.org/ns/1.0" rend="block">
			<xsl:attribute name="style" select="
					if(*:formula/@notation='latex' or *:formula/@notation='tex')
						then('tex')
					else if(*:formula/@notation='mathml' or *:formula/@notation='mml')
						then('mathml')
					else('##')
				" />
			<xsl:apply-templates select="node()" />
		</p>
	</xsl:template>

<xsl:template match="*:formula">
		<xsl:copy>
			<xsl:attribute name="notation" select="
				if(@notation='latex' or @notation='tex')
					then('tex')
				else if(@notation='mathml' or @notation='mml')
					then('mathml')
				else('##')" />
			<!-- TODO: Cf. commentaire précédent -->
			<xsl:attribute name="rend" select="if(parent::*:figure/@rend='inline') then('inline') else('block')" />
			<xsl:apply-templates select="node()" />
			<xsl:apply-templates select="following-sibling::*:graphic" />
		</xsl:copy>
	</xsl:template>
	
	<!-- TODO: ça à l’air de fonctionner…? -->
	<!-- c’est pas forcément du mml, revoir ça -->
	<!-- mais si c’est du latex je devrai pas avoir d’élément descendant de formula, right ? -->
	<xsl:template match="*:formula//element()">
		<xsl:element name="mml:{local-name()}">
			<xsl:apply-templates select="@*|node()" />
		</xsl:element>
	</xsl:template>
	
	<!-- TODO: pas d’intervention nécessaire sur le contenu des tableaux a priori ? -->
	<xsl:template match="*:figure[*:table]">
		<xsl:apply-templates select="node()" />
	</xsl:template>	
	
	<xsl:template match="*:table">
		<xsl:copy>
			<xsl:apply-templates select="@*" />
			<xsl:if test="following-sibling::*:head|preceding-sibling::*:head">
				<head xmlns="http://www.tei-c.org/ns/1.0"><xsl:apply-templates select="following-sibling::*:head/node()|preceding-sibling::*:head/node()" /></head>
			</xsl:if>
			<xsl:apply-templates select="node()" />
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="*:figure[*:table]/*:head" />
	
	<xsl:template match="*:figure/*:head[preceding-sibling::*:graphic]|*:figure/*:head[following-sibling::*:graphic]">
		<xsl:copy>
			<xsl:attribute name="style" select="'titre_figure'" />
			<xsl:apply-templates select="node()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="*:figure[@rend='inline']">
		<xsl:apply-templates select="element()" />
	</xsl:template>
	
		
	<!-- NOTES -->
	<xsl:template match="*:note[@place]">
		<xsl:copy>
			<xsl:apply-templates select="@*" />
			<xsl:attribute name="style" select="'txt_Note'" />
			<xsl:attribute name="type" select="if(@type) then(@type) else('standard')" />
			<xsl:apply-templates select="node()" />
		</xsl:copy>
	</xsl:template>
	

	<!-- BACK -->
	<!-- Bibliographie -->
	<xsl:template match="*:div[@type='bibliography']">
		<div xmlns="http://www.tei-c.org/ns/1.0" type="bibliographie" xml:id="bibliographie">
			<head style="T_1"><xsl:apply-templates select="*:head/node()" /></head>
			<xsl:choose>
				<xsl:when test="descendant::*:listBibl">
					<xsl:for-each select="descendant::*:listBibl">
						<xsl:variable name="level" select="substring-after(@type,'section')"/>
						<listBibl>
						<head>
							<xsl:attribute name="subtype" select="concat('level',$level)"/>
							<xsl:attribute name="style" select="concat('T_',$level)" />
							<xsl:apply-templates select="child::*:head/node()"/>
						</head>
							<xsl:apply-templates select="*:bibl" />
						</listBibl>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="*:bibl" />
				</xsl:otherwise>
			</xsl:choose>
		</div>
	</xsl:template>

	<xsl:template match="*:listBibl/*:head">
		<xsl:variable name="level" select="number(substring-after(parent::*:listBibl/@type, 'section'))+1" />
		<xsl:copy>
			<xsl:attribute name="style" select="concat('T_',$level)" />
			<xsl:attribute name="subtype" select="concat('level',$level)" />
			<xsl:apply-templates select="node()" />
		</xsl:copy>
	</xsl:template>
	
	<!-- les bibl sont pas numérotés pareil ('9' vs '09') : WAD ? -->
	<xsl:template match="*:div[@type='bibliography']//*:bibl">
		<xsl:copy>
			<xsl:attribute name="style" select="'txt_Bibliographie'" />
			<xsl:attribute name="type" select="'orig'" />
			<xsl:apply-templates select="@xml:id|node()" />
		</xsl:copy>
	</xsl:template>
	
	<!-- ANNEXES -->
	<xsl:template match="*:div[@type='appendix']">
		<div xmlns="http://www.tei-c.org/ns/1.0" type="annexe" >
			<xsl:apply-templates select="node()"/>
			<xsl:if test="child::*:include">
				<xsl:for-each select="child::*:include">
					<floatingText type="annexe">
						<group>
							<xsl:variable name="ref" select="./@href"/>
							<xsl:variable name="ab">
								<ab type="annexe">
									<xsl:copy-of select="document($ref)//tei:front/*"/>
									<xsl:apply-templates select="document($ref)//tei:text/*"/>
								</ab>
							</xsl:variable>
							<xsl:apply-templates select="$ab"/>
						</group>
					</floatingText>
				</xsl:for-each>
			</xsl:if>
		</div>
	</xsl:template>
	
	<!-- TYPO -->
	<xsl:template match="*:hi[@rend!='uppercase' and not(starts-with(@rend,'TEI_local'))]">
		<xsl:copy>
			<!-- 
			Pour info on aurait pu faire comme ça
			<xsl:attribute name="style" select="'typo_'||string-join(for $rend in tokenize(@rend) return $typoRef//*:style[@eq=$rend], '_')" />
			-->
			<xsl:variable name="rend" select="@rend" />
			<xsl:attribute name="style" select="concat('typo_',$typoRef//*:style[@eq=$rend])" />
			<xsl:attribute name="rend" select="if($rend='strikethrough') then('line-through') else($rend)" />
			<xsl:apply-templates select="node()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="*:hi[@rend='uppercase']">
		<xsl:apply-templates select="node()" />
	</xsl:template>

	<xsl:template match="*:hi[starts-with(@rend,'TEI_local')]">
		<hi>
			<xsl:variable name="localAtt" select="substring-after(@rend,'TEI_local')"/>
			<xsl:attribute name="style" select="concat('typo_',$localAtt)" />
			<xsl:apply-templates select="node()" />
		</hi>
	</xsl:template>
	

	<!-- CR -->
	
	<xsl:template match="*:text[@type='review']//*:listBibl|*:text[@type='commentary']//*:listBibl|*:text[@type='feature']//*:listBibl">
		<xsl:for-each select="./*:bibl[@type='display']">
			<bibl style="recension_ref">
				<xsl:apply-templates/>
			</bibl>
		</xsl:for-each>
	</xsl:template>
	
	
	<xsl:template match="*:text[@type='review']//*:bibl[@type='display']|*:text[@type='commentary']//*:bibl[@type='display']|*:text[@type='feature']//*:bibl[@type='display']" mode="bibl-review">
		<xsl:apply-templates select="."/>
	</xsl:template>
	
	<xsl:template match="*:div[@type='review_bibliography']/*:head">
		<head style="T_a">
			<xsl:apply-templates select="node()"/>
		</head>
	</xsl:template>
	
	<xsl:template match="*:div[@type='review_bibliography']//*:bibl">
		<xsl:copy>
			<xsl:attribute name="style" select="'txt_Bibliographie'" />
			<xsl:attribute name="type" select="'orig'" />
			<xsl:apply-templates select="@xml:id|node()" />
		</xsl:copy>
	</xsl:template>

	<!-- auteurs -->
    <xsl:template match="*:text[@type='review']//*:p[@rend='author-aut']|*:text[@type='commentary']//*:p[@rend='author-aut']|*:text[@type='feature']//*:p[@rend='author-aut']">
        <xsl:if test="preceding-sibling::*:bibl[1]">
		<xsl:text>
</xsl:text>
		</xsl:if>
		<docAuthor style="auteur_recension" xmlns="http://www.tei-c.org/ns/1.0">
            <name><xsl:apply-templates select="node()" /></name>
            <affiliation style="auteur_recension_institution"><xsl:apply-templates select="following-sibling::*:p[@rend='authority_affiliation']/node()" mode="author-review"/></affiliation>
        </docAuthor>
	</xsl:template>
    
    <xsl:template match="*:text[@type='review']//*:p[@rend='authority_affiliation']|*:text[@type='commentary']//*:p[@rend='authority_affiliation']|*:text[@type='feature']//*:p[@rend='authority_affiliation']"/>
    
    <xsl:template match="*:text[@type='review']//*:bibl[@type='sec_authority']|*:text[@type='commentary']//*:bibl[@type='sec_authority']|*:text[@type='feature']//*:bibl[@type='sec_authority']">
        <xsl:if test="preceding-sibling::*:bibl[1]">
		<xsl:text>
</xsl:text>
		</xsl:if>
		<docAuthor style="auteur_recension" xmlns="http://www.tei-c.org/ns/1.0">
            <name><xsl:apply-templates select="./*:author/*:persName/*:forename|./*:author/*:persName//*:surname" /></name>
            <affiliation style="auteur_recension_institution"><xsl:apply-templates select="following-sibling::*:p[@rend='authority_affiliation'][1]/node()" mode="author-review"/></affiliation>
        </docAuthor>
    </xsl:template>

</xsl:stylesheet>