<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:tei="http://www.tei-c.org/ns/1.0"
	xmlns:xlink="http://www.w3.org/1999/xlink"
    xmlns:xi="http://www.w3.org/2001/XInclude"
	exclude-result-prefixes="tei">

<xsl:output method="xml" encoding="UTF-8" indent="yes"/>

<!-- XSL de génération du fichier XML qui est parsé pour construire l'interface de paramètres des imports pour InDesign (fonctions appelées dans buildImportUEDialog) -->


<xsl:param name="fileName" select="fileName"/>
<xsl:param name="indesignVersion" select="indesignVersion"/>
<xsl:param name="fullPath" select="fullPath"/>
    
<xsl:variable name="includedDocs" select="document(//xi:include/@href)//tei:text/*"/>

<xsl:template match="/">   
    <groups>
    <pathXML><xsl:value-of select="$fullPath"/></pathXML>
        <xsl:if test="//tei:TEI[starts-with(@change, 'commons')]"> 
            <var name="commons"/>
        </xsl:if>
    	    	<xsl:if test="//tei:docAuthor or $includedDocs//tei:docAuthor or //tei:p[starts-with(@rend,'author')] or $includedDocs//tei:p[starts-with(@rend,'author')] or //tei:byline[@style='txt_auteurs'] or $includedDocs//tei:byline[@style='txt_auteurs'] or //tei:p[@rend='authorities']"> 
            <var name="author"/>
        </xsl:if>
        <xsl:if test="//tei:ab[@type='editorial_workflow'] or document(//xi:include/@href)//tei:ab[@type='editorial_workflow']"> 
            <var name="dates"/>
        </xsl:if>
        <xsl:if test="//tei:div[@type='resume_motscles']  or $includedDocs//tei:div[@type='resume_motscles'] or //tei:div[@type='abstract']  or $includedDocs//tei:div[@type='abstract']">
            <var name="abstracts"/>
        </xsl:if>
         <xsl:if test="//tei:div[@type='biography']  or $includedDocs//tei:div[@type='biography']">
            <var name="biography"/>
        </xsl:if>
        <!-- TODO problème détection table contenu dans figure, basculer sur un <when> ?-->
        <xsl:if test="//tei:figure[not(child::*:table)] or $includedDocs//tei:figure[not(child::*:table)]">
            <var name="figure"/>
        </xsl:if>
        <xsl:if test="//tei:table or $includedDocs//tei:table or //tei:figure[child::*:table] or $includedDocs//tei:figure[child::*:table]">
            <var name="table">
           		<xsl:attribute name="table-head">
           			<xsl:choose>
           				<xsl:when test="//tei:table/tei:head or $includedDocs//tei:table/tei:head or //tei:figure[child::*:table]/tei:head or $includedDocs//tei:figure[child::*:table]/tei:head">oui</xsl:when>
           				<xsl:otherwise>non</xsl:otherwise>
           			</xsl:choose>
           		</xsl:attribute>
           		<xsl:attribute name="table-note">
           			<xsl:choose>
           				<xsl:when test="//tei:table//tei:note[ancestor::tei:cell] or $includedDocs//tei:table//tei:note[ancestor::tei:cell]">oui</xsl:when>
           				<xsl:otherwise>non</xsl:otherwise>
           			</xsl:choose>
           		</xsl:attribute>
            </var>
        </xsl:if>
        <xsl:if test="//tei:div[@type='annexe'] or $includedDocs//tei:div[@type='annexe'] or //tei:div[@type='appendix'] or $includedDocs//tei:div[@type='appendix']">
            <var name="appendix"/>
        </xsl:if>
        <xsl:if test="//tei:note[@place='end'] or $includedDocs//tei:note[@place='end']"> 
            <var name="noteEnd"/>
        </xsl:if>
<!--     précédemment : test de la présence d'un floatingText > pour le traitement des notes… > mais position éditoriale : les notes d'un encadré appartiennent à l'encadré 
        <xsl:if test="//tei:body//tei:floatingText">
            <var name="floatingText"/>
        </xsl:if> -->
        <!-- même question ici ?
        <xsl:if test="//tei:back//tei:div[@type='annexe']">
            <var name="annex"/>
        </xsl:if> -->
    </groups>
</xsl:template>
    
</xsl:stylesheet>
