#include "core/translations/i18n.jsx";

removeFigureAnchors();

function removeFigureAnchors(){
    var document;

    //checks if a document is loaded
    try
    {   
        document = app.activeDocument;
    }
    catch(e)
    {
        alert(i18n('afLaunchFail'));
        return;  
    }

    //Info: must operate on parent anchoredObjectSettings
    //Only customized anchored (AnchorPosition.ANCHORED) can be released      
    for(var g = 0; g < document.allGraphics.length; g++){
        var graphic = document.allGraphics[g];
        graphic.parent.anchoredObjectSettings.anchoredPosition = AnchorPosition.ANCHORED;
        graphic.parent.anchoredObjectSettings.releaseAnchoredObject();
    }
    
    
    
    alert(i18n('afRemoveEnd')  + document.allGraphics.length + i18n('unanchored'));
}
