function prepareXSLParams(options){
        var  params = "";
        for(var key in options){
                if(options[key] instanceof Function === false){
                    params +=" " + key +"=" + options[key];
                }
        }
       return params;
}

function prepareImport(xml, params){
    var fichierXML = fichierXML = File(xml);                
    var fsName = fichierXML.fsName;
    var pathXML = fsName.substr(0, fsName.lastIndexOf(sepChemin));
    var nameXML = fsName.substr(fsName.lastIndexOf(sepChemin)+1);   
    var transfoRetroXMLOutName = "transfoRetro_" +nameXML;
    var transfoPrevXMLOutName = "transfo1_" +nameXML;
    var nouveauXMLname = "indesign_"+nameXML;
    var nouveauXML = pathXML+ sepChemin + XML_AID_HIDDEN_REPOSITORY + sepChemin+ nouveauXMLname;     
    //création du logger
    var cheminFichierLog = nouveauXML.substr(0, nouveauXML.lastIndexOf(sepChemin));
    var nomFichierLog =  "infosImport_"+ nameXML + ".txt";

    logger = new Logger(
            LOGGER_LEVELS.INFO,
            cheminFichierLog+ sepChemin + nomFichierLog)
            
    if (!File(prev_xsl).exists) {
        logger.alert(i18n('noXSL') + prev_xsl);
        exit();
    }

    if (!File(last_xsl).exists) {
        logger.alert(i18n('noXSL') + last_xsl);
        exit();
    }

    if (!File(retro).exists) {
        logger.alert(i18n('noXSL') + retro);
        exit();
    }

   //creation du répertoire .indd (sous XML) si non existant (XML_AID_HIDDEN_REPOSITORY)
    var inddFolder = new Folder(pathXML+ sepChemin + XML_AID_HIDDEN_REPOSITORY);
    if(!inddFolder.exists){
        if(!inddFolder.create()){
            throw new Exception(i18n('fail'));
        }            
    }
 
    // Transformation XSL: feuilles de transfo appliquées successivement
    var transfoRetroXMLOut = pathXML+ sepChemin + XML_AID_HIDDEN_REPOSITORY + sepChemin+ transfoRetroXMLOutName;
    var transfoPrevXMLOut = pathXML+ sepChemin + XML_AID_HIDDEN_REPOSITORY + sepChemin+ transfoPrevXMLOutName;
    if(File.fs == "Windows"){
        
        if (File(nouveauXML).exists) {
            File(nouveauXML).remove();
        }

        var newRetroXsl = retro;
        var newPrevXsl = prev_xsl;
        var newLastXsl = last_xsl;
        var newFsName = fsName;
        var transfoRetro = transfoRetroXMLOut;
        var transfo1 = transfoPrevXMLOut;
        var newXML = nouveauXML;
        var conteneurDoc = app.documents.add(false);
        conteneurDoc.importXML(File(rep_script+"uiPalette.xml"));
        var collect= new CollectElementsByXPath("//var");
        __processRuleSet(conteneurDoc.associatedXMLElement, new Array (collect));
        var idx = 0; 
        // Création d'un fichier .bat pour permettre les espaces dans les noms de fichiers (seule solution sous windows)
        if (collect.values[idx].xmlAttributes.itemByName("name").value=="commons"){
            fbat.open("w");
            fbat.writeln('"' + transform_path +'"  -s:"'+ newFsName + '" -xsl:"' + newRetroXsl + '" -o:"' + transfoRetro +'" ' + params);
            fbat.writeln('"' + transform_path +'"  -s:"'+ transfoRetro + '" -xsl:"' + newPrevXsl + '" -o:"' + transfo1 +'" ' + params);
            fbat.writeln('"' + transform_path +'"  -s:"'+ transfo1 + '" -xsl:"' + newLastXsl + '" -o:"' + newXML +'" ' + params);
            
            fbat.close();
            
            try{
                var bExec = fbat.execute();
            }
            catch(e){
                logger.alert(i18n('failbath') +  e);
                exit();
            }
            // Si au bout de 10 secondes le nouveau fichier XML n'a pas été créé on stoppe le script
            var cf = 0;
            // Problème si le fichier existe déjà!!!
            while (!File(nouveauXML).exists && cf < 1000) {
                $.sleep(1000);
                cf++;
            }
            if (cf >= 1000) {
                logger.alert(i18n('failpath'));
                exit();
            }
            fbat.remove();
        } 

        else {
            fbat.open("w");
            fbat.writeln('"' + transform_path +'"  -s:"'+ newFsName + '" -xsl:"' + newPrevXsl + '" -o:"' + transfo1 +'" ' + params);
            fbat.writeln('"' + transform_path +'"  -s:"'+ transfo1 + '" -xsl:"' + newLastXsl + '" -o:"' + newXML +'" ' + params);
            
            fbat.close();
            
            try{
                var bExec = fbat.execute();
            }
            catch(e){
                logger.alert(i18n('failbath') +  e);
                exit();
            }
            // Si au bout de 10 secondes le nouveau fichier XML n'a pas été créé on stoppe le script
            var cf = 0;
            // Problème si le fichier existe déjà!!!
            while (!File(nouveauXML).exists && cf < 1000) {
                $.sleep(1000);
                cf++;
            }
            if (cf >= 1000) {
                logger.alert(i18n('failpath'));
                exit();
            }
            fbat.remove();
        } 
        conteneurDoc.close(SaveOptions.NO)
    } 
    else{
        var newRetroXsl = makePlateformFileSystemPath (retro,"\\\\ ");
        var newPrevXsl = makePlateformFileSystemPath (prev_xsl,"\\\\ ");
        var newLastXsl = makePlateformFileSystemPath (last_xsl,"\\\\ ");
        var newFsName = makePlateformFileSystemPath (fsName,"\\\\ ");
        var transfoRetro = makePlateformFileSystemPath (transfoRetroXMLOut,"\\\\ ");
        var transfo1 = makePlateformFileSystemPath (transfoPrevXMLOut,"\\\\ ");
        var newXML = makePlateformFileSystemPath(nouveauXML,"\\\\ ");
        var newParams = makePlateformFileSystemPath (params,"\\\\ ");
        var newSaxonPath = makePlateformFileSystemPath(saxon_path,"\\\\ ");
        var loggerFile = logger.file.fsName;
        var conteneurDoc = app.documents.add(false);
	    conteneurDoc.importXML(File(rep_script+"uiPalette.xml"));
	    var collect= new CollectElementsByXPath("//var");
	    __processRuleSet(conteneurDoc.associatedXMLElement, new Array (collect));
        var idx = 0; 
        if (collect.values[idx].xmlAttributes.itemByName("name").value=="commons"){
            var cmdRetro = "java -jar "+ newSaxonPath  + " -xsl:"+newRetroXsl+ " -s:" + newFsName +" -o:" +transfoRetro + " " +params;
            var cmdRetroPrev = "java -jar "+ newSaxonPath  + " -xsl:"+newPrevXsl+ " -s:" + transfoRetro +" -o:" +transfo1 + " " +params; 
            var cmdLast = "java -jar "+ newSaxonPath  + " -xsl:"+newLastXsl+ " -s:" + transfo1 +" -o:" +newXML + " " +params; 
            var cmdCommons =  cmdRetro + " 2>&1 && " + cmdRetroPrev + " 2>&1 && " + cmdLast + " 2>&1";
            var myAppleScriptRetro = 'do shell script "' + cmdCommons + '"';
            var res;
                try{
                    resRetro = app.doScript(myAppleScriptRetro, ScriptLanguage.applescriptLanguage);
                }
                
                catch(err){
                    logger.alert(i18n('failXSL') +err);
                    exit();
                }


            logger.log(i18n('exitXSL') + res);
        }
        else{
            var cmdPrev = "java -jar "+ newSaxonPath  + " -xsl:"+newPrevXsl+ " -s:" + newFsName +" -o:" +transfo1 + " " +params;
            var cmdLast = "java -jar "+ newSaxonPath  + " -xsl:"+newLastXsl+ " -s:" + transfo1 +" -o:" +newXML + " " +params; 
            var cmdMetopes =  cmdPrev + " 2>&1 && " + cmdLast + " 2>&1";
            var myAppleScriptRetro = 'do shell script "' + cmdMetopes + '"';
            var res;
                try{
                    resRetro = app.doScript(myAppleScriptRetro, ScriptLanguage.applescriptLanguage);
                }
                
                catch(err){
                    logger.alert(i18n('failXSL') +err);
                    exit();
                }


            logger.log(i18n('exitXSL') + res);
        }
        conteneurDoc.close(SaveOptions.NO)
    }
    if (!File(nouveauXML).exists) {
        logger.alert(i18n('failtransform'));
        exit();
    }

    return nouveauXML;
}//fin prepareImport


// Mettre les éléments concernés en italique
// Selectionne le texte et  lui applique une mise en italique.
// Méthode plus longue mais fonctionne dans tous les cas, quelle que soit la police utilisée
// Ne fonctionne pas si la police utilisée n'est pas reconnue pas inDesign !
function Italique(xpath, pBar) {
    this.name = "Italique"; 
    this.xpath = xpath;
    this.apply = function(myElement, myRuleProcessor){
        with(myElement){
            if (myElement.texts.item(0).contents != "") {
                myElement.texts.item(0).select();
                app.menuActions.itemByID(119611).invoke();
            }
            pBar.hit(); // progress bar
        }
        return true;
    }
}



//fabrication de la palette d'import
function preparePalette(xml, params){
    var fichierXML = fichierXML = File(xml);                
    var fsName = fichierXML.fsName;
    var pathXML = fsName.substr(0, fsName.lastIndexOf(sepChemin));    
    if (!File(palette_xsl).exists) {
        logger.alert(i18n('noXSL') + palette_xsl);
        exit();
    }

    if(File.fs == "Windows"){
        // Création d'un fichier .bat pour permettre les espaces dans les noms de fichiers (seule solution sous windows)
	// !!!!!! À TESTER
        fbat0.open("w");
        fbat0.writeln('"' +transform_path +'"  -s:"'+ fsName + '" -xsl:"' + palette_xsl + '" -o:"' + rep_script +'uiPalette.xml" ' + params);
        
        fbat0.close();
        
        try{
            var bExec = fbat0.execute();
        }
        catch(e){
            logger.alert(i18n('failbath') +  e);
            exit();
        }
        // Si au bout de 10 secondes le nouveau fichier XML n'a pas été créé on stoppe le script
        var cf = 0;
        // Problème si le fichier existe déjà!!!
/*        while (!File(nouveauXML).exists && cf < 1000) {
            $.sleep(1000);
            cf++;
        }
        if (cf >= 1000) {
            logger.alert(i18n('failpath'));
            exit();
        }*/
        fbat.remove();
    } 
    else{
        var newPaletteXsl = makePlateformFileSystemPath (palette_xsl,"\\\\ ");
        var newFsName = makePlateformFileSystemPath (fsName,"\\\\ ");
        var transfo1 = makePlateformFileSystemPath (rep_script,"\\\\ ");
        var newParams = makePlateformFileSystemPath (params,"\\\\ ");
        var newSaxonPath = makePlateformFileSystemPath(saxon_path,"\\\\ ");
        //necessite saxon9b.
        var cmdPalette = "java -jar "+ newSaxonPath  + " -xsl:"+newPaletteXsl+ " -s:" + newFsName +" -o:" +transfo1 + "uiPalette.xml " + newParams +" fullPath="+newFsName; 
        var cmd = cmdPalette + " 2>&1 ";
        var myAppleScript = 'do shell script "' + cmd + '"';
        var res;
        try{
            res = app.doScript(myAppleScript, ScriptLanguage.applescriptLanguage);
        }
        catch(err){
	    alert(err);
        }

        //logger.log(i18n('exitXSL') + res);
    }

}
