﻿var LOGGER_MODES = {
    CLIENT:{},
    SERVER:{}
};

var LOGGER_LEVELS ={
    DEBUG:{value: 1},
    INFO:{value: 2},
    WARNING:{value: 3},
    ERROR:{value: 4},
    FATAL:{value: 5}
    
};

function Logger(level, filePath){
    this.mode = app.name.indexOf("Indesign Server") == -1 
        ? LOGGER_MODES.CLIENT 
        : LOGGER_MODES.SERVER;
    this.level = level;
    this.file = new File(filePath);
    this.file.encoding = "UTF-8";
    this.file.open("w");
    
    this.setLevel = function(levelName){
      this.level = levelName;  
    };
    
    //writes blank line in log file
    this.cr = function(){
        this.file.writeln("");
    };
    
    this.log = function(message, levelName){        
        this.file.writeln((typeof levelName !== 'undefined' ? (levelName + " = ") : "") + message);
    };
    this.debug = function(message){
      if(this.level.value <= LOGGER_LEVELS.DEBUG.value)
        this.log(message, "DEBUG");
    };
    this.info = function(message){
        if(this.level.value <= LOGGER_LEVELS.INFO.value)
            this.log(message, "INFO");
    };
    this.warn = function(message){
        if(this.level.value <= LOGGER_LEVELS.WARNING.value)
            this.log(message, "WARNING");      
    };
    this.error = function(message){
        if(this.level.value <= LOGGER_LEVELS.ERROR.value)
            this.log(message, "ERROR");
    };
    this.fatal = function(message){
        if(this.level.value <= LOGGER_LEVELS.FATAL.value)
            this.log(message, "FATAL");
    };
    this.alert = function(message, levelName){
        if(this.mode == LOGGER_MODES.CLIENT){
            alert(message)
            }
        else{
            levelName = (typeof levelName !== 'undefined') ? levelName : "FATAL";
            this.log(message, levelName);
        }
    };
    this.close = function(){
        this.file.close();
    }
    
}