#include "translations/i18n.jsx";
#targetengine "session";

function MaquetteChooser(label, parentPanel, filter){
     this.pane = parentPanel.add("group");
     this.textLab = this.pane.add("statictext", [0, 10, 200, 30], i18n('template') +" '" +label+"'" + i18n('dp'));
     this.typeField = this.pane.add("edittext", [0, 0, 550, 20], "");
     this.typeButton = this.pane.add ("button", undefined, i18n('dotdotdot'));
     var tf = this.typeField;
     this.typeButton.onClick= function () 
     {
   
          tf.text = File.openDialog(i18n('booktemplate'), (File.fs == "Windows") ?  i18n('booktemplatefilter') : filter).fsName;

     }
     return this;
}

function  figPalette(parentGroup) {
    var figuresPane = parentGroup.add("panel", undefined, undefined, {name: "figuresPane"}); 
    figuresPane.text = i18n('figTitle'); 
    figuresPane.preferredSize.height = 20; 
    figuresPane.orientation = "column"; 
    figuresPane.alignChildren = ["left","top"]; 
    figuresPane.spacing = 10; 
    figuresPane.margins = [10,10,49,10];  
    figuresPane.preferredSize.width = 200; 
    
    // import des images en tableau ou libre
    var figuresMode = figuresPane.add("group", undefined, {name: "figuresMode"}); 
    figuresMode.orientation = "row"; 
    figuresMode.alignChildren = ["left","center"]; 
    figuresMode.spacing = 10; 
    figuresMode.margins = 0;
    var figuresPaneText = figuresMode.add("statictext", undefined, undefined, {name: "figuresPaneText"}); 
    figuresPaneText.text = i18n('figparam');
    figuresPaneText.preferredSize.width = 180; 
    var figinTable = figuresMode.add("radiobutton", undefined, undefined, {name: "figinTable"}); 
    figinTable.text = i18n('table'); 
    figinTable.value = true; 
    figinTable.preferredSize.width = 150; 
    //en = figinTable.preferredSize.width = 175; 
    var figHeap = figuresMode.add("radiobutton", undefined, undefined, {name: "figHeap"}); 
    figHeap.text = i18n('heap'); 
        
    figHeap.onClick = function(){
		figTitlebelow.enabled = false;
    	figTitleRight.enabled = false;
    	figTitleUp.enabled = false;
	}
	
    //position des titres
    var figTitle = figuresPane.add("group", undefined, {name: "figTitle"}); 
    figTitle.orientation = "row"; 
    figTitle.alignChildren = ["left","center"]; 
    figTitle.spacing = 10; 
    figTitle.margins = 0;
    var figTitleText = figTitle.add("statictext", undefined, undefined, {name: "figTitleText"}); 
    figTitleText.text = i18n('figTitleparam'); 
    figTitleText.preferredSize.width = 180;

    var figTitlebelow = figTitle.add("radiobutton", undefined, undefined, {name: "figTitlebelow"}); 
    figTitlebelow.text = i18n('figTitlebelow'); 
    figTitlebelow.value = true; 
    figTitlebelow.preferredSize.width = 150;
    //en = figTitlebelow.preferredSize.width = 175;

    var figTitleRight = figTitle.add("radiobutton", undefined, undefined, {name: "figTitleRight"}); 
    figTitleRight.text = i18n('figTitleRight'); 
    figTitleRight.preferredSize.width = 150;
    //en = figTitleRight.preferredSize.width = 175;

    var figTitleUp = figTitle.add("radiobutton", undefined, undefined, {name: "figTitleUp"}); 
    figTitleUp.text = i18n('figTitleUp'); 
    
    //résolution
    var resolPane = figuresPane.add("group", undefined, {name: "resolPane"}); 
    resolPane.orientation = "row"; 
    resolPane.alignChildren = ["left","center"]; 
    resolPane.spacing = 10; 
    resolPane.margins = 0;
    
    var resolPaneText = resolPane.add("statictext", undefined, undefined, {name: "resolPaneText"}); 
    resolPaneText.text = i18n('imgresparam'); 
    resolPaneText.preferredSize.width = 180;
    var rbhr = resolPane.add("radiobutton", undefined, undefined, {name: "rbhr"}); 
    rbhr.text = i18n('imghr'); 
    rbhr.value = true; 
    rbhr.preferredSize.width = 150; 
    //en = rbhr.preferredSize.width = 175; 
    var rbmr = resolPane.add("radiobutton", undefined, undefined, {name: "rbmr"}); 
    rbmr.text = i18n('imgmr'); 
    rbmr.preferredSize.width = 150; 
    //en = rbmr.preferredSize.width = 175; 
    var rbbr = resolPane.add("radiobutton", undefined, undefined, {name: "rbbr"}); 
    rbbr.text = i18n('imgbr'); 

    var opts = new Array()
    opts.push(figuresMode)
    opts.push(figTitle)
    opts.push(resolPane)
    return opts   
}

function  tablePalette(parentGroup,tablehead,tablenote,version) {
	
	if (tablehead == 'oui' || tablenote == 'oui') {
    var tablePane = parentGroup.add("panel", undefined, undefined, {name: "tablePane"}); 
    tablePane.text = i18n('tables'); 
    tablePane.preferredSize.height = 34; 
    tablePane.orientation = "column"; 
    tablePane.alignChildren = ["left","top"]; 
    tablePane.spacing = 10;  
    tablePane.margins = [10,10,163,10];  
	tablePane.preferredSize.width = 200; 
	} 
	
	if (tablehead == 'oui') {
		var tableTitlePane = tablePane.add("group", undefined, {name: "tableTitlePane"}); 
	    tableTitlePane.orientation = "row"; 
    	tableTitlePane.alignChildren = ["left","center"]; 
	    tableTitlePane.spacing = 10; 
    	tableTitlePane.margins = 0;
    
	    var tableTitle = tableTitlePane.add("statictext", undefined, undefined, {name: "tableTitle"}); 
		tableTitle.text = i18n('tableTitleparam'); 
		tableTitle.preferredSize.width = 180; 
	
		var tableUp = tableTitlePane.add("radiobutton", undefined, undefined, {name: "tableUp"}); 
		tableUp.text = i18n('tableTitlebefore'); 
		tableUp.value = true; 
		tableUp.preferredSize.width = 150;
    
	    var tableBot = tableTitlePane.add("radiobutton", undefined, undefined, {name: "tableBot"}); 
   		tableBot.text = i18n('tableTitleafter');
	   	tableBot.preferredSize.width = 150;
	}
	
	if (tablenote == 'oui') {
   		if (version >= 14)
		{
			var tableNotePane = tablePane.add("group", undefined, {name: "tableNotePane"}); 
    		tableNotePane.orientation = "row"; 
    		tableNotePane.alignChildren = ["left","center"]; 
    		tableNotePane.spacing = 10; 
    		tableNotePane.margins = 0;
 
 			var tableNoteText = tableNotePane.add("statictext", undefined, undefined, {name: "tableNoteText"}); 
    		tableNoteText.text = i18n('notestable'); 
    		tableNoteText.preferredSize.width = 180;
    
    		var ntindd = tableNotePane.add("radiobutton", undefined, undefined, {name: "ntindd"}); 
		    ntindd.text = i18n('ntindd'); 
		    ntindd.value = true; 
		    ntindd.preferredSize.width = 172; 
		    
		    var ntmet = tableNotePane.add("radiobutton", undefined, undefined, {name: "ntmet"}); 
    		ntmet.text = i18n('ntmet'); 		    
		} else {
			}
		}
   	
   	if (tablehead == 'non' && tablenote == 'non') {
   		var opts = new Array()
		opts.push("NA")
   	} else {
   		var opts = new Array()
    	opts.push(tablePane)
   	}
   	 	
    return opts
}

function  endnotePalette(parentGroup,version) {

	   	if (version >= 13)
		{
		var endnotePane = parentGroup.add("panel", undefined, undefined, {name: "endnotePane"}); 
   		    endnotePane.text = i18n('notesend'); 
    		endnotePane.orientation = "row"; 
	        endnotePane.alignChildren = ["left","top"]; 
    	    endnotePane.spacing = 10; 
        	endnotePane.margins = 10; 
        	endnotePane.margins = [10,10,159,10]; 

		var endnoteText = endnotePane.add("statictext", undefined, undefined, {name: "endnoteText"}); 
    	   	endnoteText.text = i18n('notesendlabel'); 
       		endnoteText.preferredSize.width = 180;

		var nemet = endnotePane.add("radiobutton", undefined, undefined, {name: "nemet"}); 
     	    nemet.text = i18n('nemet');  
    	    nemet.value = true; 
    	    //en = nemet.preferredSize.width = 175;

		var neindd = endnotePane.add("radiobutton", undefined, undefined, {name: "neindd"}); 
   	  	    neindd.text = i18n('neindd'); 
   	    	neindd.preferredSize.width = 150;	
   	    	
   	    var opts = new Array()
    	opts.push(nemet)
    		    
		} else {
			var opts = new Array()
    		opts.push("nemet")
		}

       
    return opts
}
    
function  abstractPalette(parentGroup) {
    var abstractPane = parentGroup.add("panel", undefined, undefined, {name: "abstractPane"}); 
    abstractPane.text = i18n('keywordsparam'); 
    abstractPane.orientation = "column"; 
    abstractPane.alignChildren = ["left","top"]; 
    abstractPane.spacing = 10; 
    abstractPane.margins = [10,10,163,10];  
    
    var abstractYN = abstractPane.add("group", undefined, {name: "abstractYN"}); 
    abstractYN.orientation = "row"; 
    abstractYN.alignChildren = ["left","center"]; 
    abstractYN.spacing = 10; 
    abstractYN.margins = 0; 

    var abstractTitle = abstractYN.add("statictext", undefined, undefined, {name: "abstractTitle"}); 
    abstractTitle.text = i18n('keywordsposition'); 
    abstractTitle.preferredSize.width = 180; 

    var abstractY = abstractYN.add("radiobutton", undefined, undefined, {name: "abstractY"}); 
    abstractY.text = i18n('Y'); 
    abstractY.value = true; 
    abstractY.preferredSize.width = 150; 
    //en = abstractY.preferredSize.width = 175; 

    var abstractN = abstractYN.add("radiobutton", undefined, undefined, {name: "abstractN"}); 
    abstractN.text = i18n('N'); 
    abstractN.preferredSize.width = 150; 
    
    abstractN.onClick = function(){
		abstractLangAll.enabled = false;
    	abstractLangP.enabled = false;
	}

     abstractY.onClick = function(){
        abstractLangAll.enabled = true;
        abstractLangP.enabled = true;
    }

    var abstractLang = abstractPane.add("group", undefined, {name: "abstractLang"}); 
    abstractLang.orientation = "row"; 
    abstractLang.alignChildren = ["left","center"]; 
    abstractLang.spacing = 10; 

	var abstractLangTitle = abstractLang.add("statictext", undefined, undefined, {name: "abstractLangTitle"}); 
    abstractLangTitle.preferredSize.width = 180;

    var abstractLangAll = abstractLang.add("radiobutton", undefined, undefined, {name: "abstractLangAll"}); 
    abstractLangAll.text = i18n('keywordsAll');
    abstractLangAll.value = true; 
    abstractLangAll.preferredSize.width = 150; 
    //en = abstractLangAll.preferredSize.width = 175; 

    var abstractLangP = abstractLang.add("radiobutton", undefined, undefined, {name: "abstractLangP"}); 
    abstractLangP.text = i18n('keywordsMainlang'); 
    abstractLangP.preferredSize.width = 150;
   	
   	var opts = new Array()
    	opts.push(abstractYN)
    	opts.push(abstractLang)
    return opts
}

function  authorPalette(parentGroup) {
    var authorPane = parentGroup.add("panel", undefined, undefined, {name: "authorPane"}); 
    authorPane.text = i18n('authorparam'); 
    authorPane.preferredSize.height = 34; 
    authorPane.orientation = "row"; 
    authorPane.alignChildren = ["left","top"]; 
    authorPane.spacing = 5;  
    
    var authorTitle = authorPane.add("statictext", undefined, undefined, {name: "authorTitle"}); 
	authorTitle.text = i18n('authorposition'); 
	authorTitle.preferredSize.width = 180; 
	
	var authorafter = authorPane.add("radiobutton", undefined, undefined, {name: "authorafter"}); 
	authorafter.text = i18n('authorafter'); 
	authorafter.value = true; 
	authorafter.preferredSize.width = 150;
	//en = authorafter.preferredSize.width = 175;
    
    var authorbefore = authorPane.add("radiobutton", undefined, undefined, {name: "authorbefore"}); 
   	authorbefore.text = i18n('authorbefore');
   	authorbefore.preferredSize.width = 150;
   	//en = authorbefore.preferredSize.width = 175;
   	
   	var authorsign = authorPane.add("radiobutton", undefined, undefined, {name: "authorsign"}); 
   	authorsign.text = i18n('authorsign');
   	authorsign.preferredSize.width = 148;
   	//en = authorsign.preferredSize.width = 200;
   	
   	var opts = new Array()
    	opts.push(authorPane)
    return opts
}

function  datesPalette(parentGroup) {
    var datesPane = parentGroup.add("panel", undefined, undefined, {name: "datesPane"}); 
    datesPane.text = i18n('datesparam'); 
    datesPane.preferredSize.height = 34; 
    datesPane.orientation = "row"; 
    datesPane.alignChildren = ["left","top"]; 
    datesPane.spacing = 5;  
    
    var datesTitle = datesPane.add("statictext", undefined, undefined, {name: "datesTitle"}); 
    datesTitle.text = i18n('datesposition'); 
    datesTitle.preferredSize.width = 180; 

    var datesNone = datesPane.add("radiobutton", undefined, undefined, {name: "datesNone"}); 
    datesNone.text = i18n('datesNone');
    datesNone.value = true; 
    datesNone.preferredSize.width = 150;
    
    var datesEnd = datesPane.add("radiobutton", undefined, undefined, {name: "datesEnd"}); 
    datesEnd.text = i18n('datesEnd'); 
    datesEnd.preferredSize.width = 150;
    
    var datesFront = datesPane.add("radiobutton", undefined, undefined, {name: "datesFront"}); 
    datesFront.text = i18n('datesFront');
    datesFront.preferredSize.width = 148;
    
    var opts = new Array()
        opts.push(datesPane)
    return opts
}

function appendixPalette(parentGroup) {
    var appendixPane = parentGroup.add("panel", undefined, undefined, {name: "appendixPane"}); 
    appendixPane.text = i18n('appendixparam'); 
    appendixPane.preferredSize.height = 34; 
    appendixPane.orientation = "row"; 
    appendixPane.alignChildren = ["left","top"]; 
    appendixPane.spacing = 5;  
    
    var appendixTitle = appendixPane.add("statictext", undefined, undefined, {name: "appendixTitle"}); 
    appendixTitle.text = i18n('appendixposition'); 
    appendixTitle.preferredSize.width = 180; 
    
    var appendixafter = appendixPane.add("radiobutton", undefined, undefined, {name: "appendixafter"}); 
    appendixafter.text = i18n('appendixafter'); 
    appendixafter.value = true; 
    appendixafter.preferredSize.width = 212;
    
    var appendixbefore = appendixPane.add("radiobutton", undefined, undefined, {name: "appendixbefore"}); 
    appendixbefore.text = i18n('appendixbefore');
    appendixbefore.preferredSize.width = 240;
    
    var opts = new Array()
        opts.push(appendixPane)
    return opts
}

function  biographyPalette(parentGroup) {
    var biographyPane = parentGroup.add("panel", undefined, undefined, {name: "biographyPane"}); 
    biographyPane.text = i18n('biographyparam'); 
    biographyPane.orientation = "column"; 
    biographyPane.alignChildren = ["left","top"]; 
    biographyPane.spacing = 10; 
    biographyPane.margins = [10,10,163,10];  
    
    var biographyYN = biographyPane.add("group", undefined, {name: "biographyYN"}); 
    biographyYN.orientation = "row"; 
    biographyYN.alignChildren = ["left","center"]; 
    biographyYN.spacing = 10; 
    biographyYN.margins = 0; 

    var biographyTitle = biographyYN.add("statictext", undefined, undefined, {name: "biographyTitle"}); 
    biographyTitle.text = i18n('biographyposition'); 
    biographyTitle.preferredSize.width = 180; 

    var biographyY = biographyYN.add("radiobutton", undefined, undefined, {name: "biographyY"}); 
    biographyY.text = i18n('Y'); 
    biographyY.value = true; 
    biographyY.preferredSize.width = 150; 
    //en = abstractY.preferredSize.width = 175; 

    var biographyN = biographyYN.add("radiobutton", undefined, undefined, {name: "biographyN"}); 
    biographyN.text = i18n('N'); 
    biographyN.preferredSize.width = 150; 
    
    biographyN.onClick = function(){
        biographyPosUE.enabled = false;
        biographyPosVol.enabled = false;
    }

        biographyY.onClick = function(){
        biographyPosUE.enabled = true;
        biographyPosVol.enabled = true;
    }

    var biographyPos = biographyPane.add("group", undefined, {name: "biographyPos"}); 
    biographyPos.orientation = "row"; 
    biographyPos.alignChildren = ["left","center"]; 
    biographyPos.spacing = 10; 

    var biographyPosTitle = biographyPos.add("statictext", undefined, undefined, {name: "biographyPosTitle"}); 
    biographyPosTitle.preferredSize.width = 180;

    var biographyPosUE = biographyPos.add("radiobutton", undefined, undefined, {name: "biographyPosUE"}); 
    biographyPosUE.text = i18n('biographyPosUE');
    biographyPosUE.value = true; 
    biographyPosUE.preferredSize.width = 150; 
    //en = abstractLangAll.preferredSize.width = 175; 

    var biographyPosVol = biographyPos.add("radiobutton", undefined, undefined, {name: "biographyPosVol"}); 
    biographyPosVol.text = i18n('biographyPosVol'); 
    biographyPosVol.preferredSize.width = 150;
    
    var opts = new Array()
        opts.push(biographyYN)
        opts.push(biographyPos)
    return opts
}

function AnchoredFrameTagUI(parentPanel){
    this.tagGroup = parentPanel.add("group");
    this.tagGroup.add ("statictext", [0, 0, 150, 30], i18n('element'));
    this.tagsDropDown = this.tagGroup.add ("dropdownlist", [0, 0, 150, 30], tags);
    
    this.attributeNameGroup = parentPanel.add("group");
    this.attributeNameGroup.add ("statictext", [0, 0, 150, 30], i18n('attribute'));
    this.attributeNamesDropDown = this.attributeNameGroup.add ("dropdownlist", [0, 0, 150, 30],  new Array());
    
    this.attributeValueGroup =  parentPanel.add("group");
    this.attributeValueGroup.add ("statictext", [0, 0, 150, 30], i18n('value'));
    this.attributeValuesDropDown = this.attributeValueGroup.add ("dropdownlist", [0, 0, 150, 30], new Array());

    this.styleGroup =  parentPanel.add("group");
    this.styleGroup.add ("statictext", [0, 0, 150, 30], i18n('objectstyle'));
    this.stylesDropDown = this.styleGroup.add ("dropdownlist", [0, 0, 150, 30], styles);
    this.stylesDropDown.selection = 0; 
     
    return this;
}

function TagNameAndValueUI(parentPanel, tag){
    this.tagGroup = parentPanel.add("group");
    this.tagGroup.add ("statictext", [0, 0, 150, 30], i18n('element'));
    this.tagGroup.add ("statictext", [0, 0, 150, 30], tag);
    
    this.attributeNameGroup = parentPanel.add("group");
    this.attributeNameGroup.add ("statictext", [0, 0, 150, 30], i18n('attribute'));
    this.attributeNamesDropDown = this.attributeNameGroup.add ("dropdownlist", [0, 0, 150, 30],  new Array());
    
    
    this.attributeValueGroup =  parentPanel.add("group");
    this.attributeValueGroup.add ("statictext", [0, 0, 150, 30], i18n('value'));
    this.attributeValuesDropDown = this.attributeValueGroup.add ("dropdownlist", [0, 0, 150, 30], new Array());
    
    return this;
}

	
function ProgressBar(title)
{  
         var w = new Window('palette', ' '+title, {x:0, y:0, width:340, height:60}),
              pb = w.add('progressbar', {x:20, y:12, width:300, height:12}, 0, 100),
              st = w.add('statictext', {x:10, y:36, width:320, height:20}, '');
         st.justify = 'center';
         w.center();
         this.reset = function(msg,maxValue)
              {
              st.text = msg;
              pb.value = 0;
              pb.maxvalue = maxValue||0;
              pb.visible = !!maxValue;
              w.show();
              };
         this.hit = function() {++pb.value;};
         this.hide = function() {w.hide();};
         this.close = function() {w.close();};
};


//fills the attribute names drop down list occording to a tagName selection
function updateAttributeNamesListForTag(ui, tagName)
{
         ui.attributeNamesDropDown.removeAll();
         ui.attributeValuesDropDown.removeAll();
         ui.attributeValuesDropDown.add("item", ALL_VALUES);
         col = new CollectAttributeNames(tagName);
         typeRuleSet = new Array(col);
        __processRuleSet(myDocument.xmlElements.item(0), typeRuleSet);
        names = col.names.unique();
        for(i = 0; i < names.length; i++)
            ui.attributeNamesDropDown.add("item", names[i]);
}

//fills the attribute values drop down list accordinf to an attribute name selection
function updateAttributeValuesListForTag(ui, tagName, attributeName)
{
        ui.attributeValuesDropDown.removeAll(); 
        col = new CollectAttributeValues(tagName, attributeName);
        typeRuleSet = new Array(col);
        __processRuleSet(myDocument.xmlElements.item(0), typeRuleSet);
        values = col.values.unique();
        for(i = 0; i < values.length; i++){
            ui.attributeValuesDropDown.add ("item", values[i]);
        }
        ui.attributeValuesDropDown.selection = 0;            
}


function buildImportUEDialog() {

    var palette = new Window("palette", i18n('importTitle'), undefined, {resizeable: true});
    palette.location = [300, 250];
    palette.alignChildren = "left";
    var main = palette.add("group");
    main.orientation = "column";
    main.alignChildren = "left";

    //fichier XML  
    var xmlPane = main.add("group");
    xmlPane.add("statictext", [0, 10, 150, 30],  i18n('xmlFile'));
    var xmlField = xmlPane.add("edittext", [0, 0, 550, 20], "");
    var xmlButton = xmlPane.add("button", undefined, i18n('dotdotdot'));

    //maquette   
    var maquettePane = main.add("group");
    maquettePane.add("statictext", [0, 10, 150, 30], i18n('template'));
    var maquetteField = maquettePane.add("edittext", [0, 0, 550, 20], "");
    var maquetteButton = maquettePane.add("button", undefined, i18n('dotdotdot'));
    maquetteButton.onClick = function ()
    {
        maquetteField.text = File.openDialog(i18n('templateChooser'), (File.fs == "Windows") ? i18n('inddFileFilter') : inddFilter).fsName;

    }
    
    var versionPane = main.add("group");
	var versionText = versionPane.add("statictext", undefined, undefined, {name: "versionText"}); 
    versionText.text = "InDesign version : " + version ; 

    //faire valider par *PyB* la suppression des deux lignes suivantes
    var paletteFigures = new Array();
    var paletteTable = new Array();
    var paletteAbstract = new Array();
    var paletteEndnote = new Array();
    var paletteAuthor = new Array();
    var paletteDates = new Array();
    var paletteAppendix = new Array();
    var paletteBiography = new Array();
    var dialog = main.add("group");
    //dialog.preferredSize.width = 820;  //ici changement de la boîte de dialogue redessinée (contenant les paramètres d'import)
    dialog.orientation = "column"; 
    dialog.alignChildren = ["left","top"];

    xmlButton.onClick = function ()
    {
        xmlField.text = File.openDialog(i18n('chooseXMLFile'), (File.fs == "Windows") ? i18n('XMLFileFilter') : xmlFilter).fsName;
	try  {
	    var options = new Array();
            options["indesignVersion"] = version;
	    	options["fileName"] = xmlField.text;
	    var params = prepareXSLParams(options);
	    preparePalette(xmlField.text, params)

	    if (dialog.children.length>0) {
		for (var z = dialog.children.length-1; z >= 0; z--) {
		    dialog.remove(z)
		}
	    }

	    var conteneurDoc = app.documents.add(false);//on charge le doc sans afficher de fenêtre dans la GUI d'AID
	    conteneurDoc.importXML(File(rep_script+"uiPalette.xml"));
	    var collect= new CollectElementsByXPath("//var");
	    __processRuleSet(conteneurDoc.associatedXMLElement, new Array (collect));
	    if (collect.values.length == 0)
	    {
		paletteFigures.push("NA");
		paletteTable.push("NA");
		paletteAbstract.push("NA");
		paletteEndnote.push("NA");
		paletteAuthor.push("NA");
        paletteDates.push("NA");
        paletteAppendix.push("NA");
        paletteBiography.push("NA");
	    } else {
	    for(var idx = 0; idx< collect.values.length; idx++){
		if (collect.values[idx].xmlAttributes.itemByName("name").value=="figure")
		{
		    paletteFigures = new figPalette(dialog);
		} else {
		    paletteFigures.push("NA")
		}
		
		if (collect.values[idx].xmlAttributes.itemByName("name").value=="table")
		{
		    paletteTable = new tablePalette(dialog,collect.values[idx].xmlAttributes.itemByName("table-head").value,collect.values[idx].xmlAttributes.itemByName("table-note").value,version);

		} else {
		    paletteTable.push("NA");
		}

		if (collect.values[idx].xmlAttributes.itemByName("name").value=="abstracts")
		{
		    paletteAbstract = new abstractPalette(dialog);
		} else {
		    paletteAbstract.push("NA");
		}
		
		if (collect.values[idx].xmlAttributes.itemByName("name").value=="noteEnd")
		{
		    paletteEndnote = new endnotePalette(dialog,version);		    
		} else {
		    paletteEndnote.push("NA");
		}

		if (collect.values[idx].xmlAttributes.itemByName("name").value=="author")
		{
		    paletteAuthor = new authorPalette(dialog);
		} else {
		    paletteAuthor.push("NA");
		}

        if (collect.values[idx].xmlAttributes.itemByName("name").value=="dates")
        {
            paletteDates = new datesPalette(dialog);
        } else {
            paletteDates.push("NA");
        }
	    
        if (collect.values[idx].xmlAttributes.itemByName("name").value=="appendix")
        {
            paletteAppendix = new appendixPalette(dialog);
        } else {
            paletteAppendix.push("NA");
        }
                if (collect.values[idx].xmlAttributes.itemByName("name").value=="biography")
        {
            paletteBiography = new biographyPalette(dialog);
        } else {
            paletteBiography.push("NA");
        }
        }
	}
	    palette.layout.layout(true);
	    conteneurDoc.close(SaveOptions.NO)
	}
	catch(e) {
	    alert(e)
	}
    }


    var buttons = palette.add("group");
    var applyButton = buttons.add("button", undefined, i18n('apply'));
    var closeButton = buttons.add("button", undefined, i18n('close'));
    closeButton.onClick = function ()
    {
        palette.close();

    }
    
/*var debugButton = buttons.add("button", undefined, "Paramètres…");
    debugButton.onClick = function ()
    {
	alert("- Note de tableau : " + paletteTable[0].tableNotePane.ntindd.value + "\r - Position des titres : " + paletteTable[0].tableTitlePane.tableUp.value)
	}*/

    /*var debugButton = buttons.add("button", undefined, "Paramètres…");
    debugButton.onClick = function ()
    {
	alert("Paramètres \r" +
	"Author\r- Position : " + paletteAuthor[0].authorafter.value + " " + paletteAuthor[0].authorbefore.value + " " + paletteAuthor[0].authorsign.value +
	"\r\rRésumés et mots-clés\r- Placement : " + paletteAbstract[0].abstractY.value + " " + paletteAbstract[0].abstractN.value +"\r- Langue : " + paletteAbstract[1].abstractLangAll.value + " " + paletteAbstract[1].abstractLangP.value + 
	"\r\rFigures" + "\n- Mode : " + paletteFigures[0].figinTable.value + " " +  paletteFigures[0].figHeap.value + " \r- Position du titre : " +  paletteFigures[1].figTitlebelow.value + " " + paletteFigures[1].figTitleRight.value + "\r- Résolution : " + paletteFigures[2].rbhr.value + " " + paletteFigures[2].rbmr.value + " " + paletteFigures[2].rbbr.value + 
	"\r\rTable\r- Position des titres : " + paletteTable[0].tableUp.value + " " + paletteTable[0].tableBot.value)
    }*/

    applyButton.onClick = function ()
    {
        try {

            if (xmlField.text == "" || maquetteField.text == "") {
                alert(i18n('chooseFiles'));
                return;
            }

        var resolution;//images resolution
	    var figuresMode;// = rbFigTab.value;
	    if (paletteFigures[0] == "NA") {
		resolution = "NA";
		figuresMode = "NA";
		figuresVert = "NA";
	    } else {
		if (paletteFigures[2].rbhr.value == true)
                    resolution = "hr";
		else if (paletteFigures[2].rbbr.value == true) {
                    resolution = "br";
		}
		else {
                    resolution = "mr";
		}

	    if (paletteFigures[0].figinTable.value == true)
                figuresMode = "tab";
	    else if (paletteFigures[0].figHeap.value == true) {
                figuresMode = "heap";
	    }
	    else {
                figuresMode = "cell";
	    }
	    
	    var figuresVert;
           if (paletteFigures[1].figTitlebelow.value == true)
               figuresVert = "beforeTitle";
           else if (paletteFigures[1].figTitleRight.value == true) {
               figuresVert = "afterTitle";
           }
           else {
               figuresVert = "figTitleUp";
         }
		}
		
        var authorPlace;
	    if (paletteAuthor[0] == "NA") {
		authorPlace = "NA";
	    } else {
		if (paletteAuthor[0].authorbefore.value == true)
                    authorPlace = "beforeTitle";
		else if (paletteAuthor[0].authorafter.value == true) {
                    authorPlace = "afterTitle";
		}
		else {
                    authorPlace = "end";
		}
	    }

        var datesPlace;
        if (paletteDates[0] == "NA") {
        datesPlace = "NA";
        } else {
        if (paletteDates[0].datesFront.value == true)
                    datesPlace = "datesFront";
        else if (paletteDates[0].datesEnd.value == true) {
                    datesPlace = "datesEnd";
        }
        else {
                    datesPlace = "datesNone";
        }
        }

	    var withAbstractAndKeywords
	    var textLang
	    if (paletteAbstract[0] == "NA") {
		withAbstractAndKeywords = "NA";
		textLang = "NA";
	    } else {
		withAbstractAndKeywords = paletteAbstract[0].abstractY.value;
		textLang = paletteAbstract[1].abstractLangP.value;
	    }

        var appendixPlace;
        if (paletteAppendix[0] == "NA") {
        appendixPlace = "NA";
        } else {
        if (paletteAppendix[0].appendixbefore.value == true)
                    appendixPlace = "beforeTitle";
        else if (paletteAppendix[0].appendixafter.value == true) {
                    appendixPlace = "afterTitle";
        }
    
        }

        var withBiography
        var textBio
        if (paletteBiography[0] == "NA") {
        withBiography = "NA";
        textBio = "NA";
        } else {
        withBiography = paletteBiography[0].biographyY.value;
        textBio = paletteBiography[1].biographyPosUE.value;
        }
	    
	    var endnote
	    if (paletteEndnote[0] == "NA") {
			endnote = "NA";
	    } else {
		endnote = paletteEndnote[0].value;
	    }
	    
	    // **!!** ici un problème avec la variable table quand elle n'existe pas !!
	    // définir la variable notesTables ici aussi ? (ask PyB)
	    var table
	    if (paletteTable[0] == "NA" || !paletteTable[0].tableTitlePane) {
		table = "NA";
	    } else {
		table = paletteTable[0].tableTitlePane.tableUp.value;
	    }

            
            if(File.fs != "Windows"){
                var iconoPath = (new File(xmlField.text)).parent.parent.fsName + sepChemin + "icono" + sepChemin + resolution + sepChemin;
                iconoPath = makePlateformFileSystemPath(iconoPath, "\\\\ ");
            }
            else{
                var iconoPath = (new File(xmlField.text)).parent.parent.fsName + sepChemin + "icono" + sepChemin + resolution + sepChemin;
            }


            var notesTables;
    	    if (paletteTable[0] == "NA" || !paletteTable[0].tableNotePane || paletteTable[0].tableNotePane.ntindd.value == true)
                notesTables = "footnotes";
		else {
		    notesTables = "notesInTables";
            }

            var options = new Array();
            options["figuresMode"] = figuresMode;
            options["figuresVert"] = figuresVert;
            options["table"] = table;
            options["authorLocation"] = authorPlace;
            options["datesLocation"] = datesPlace;
            options["withAbstract"] = withAbstractAndKeywords;
            options["lang"] = textLang;
            options["iconoPath"] = iconoPath;
            options["resolution"] = resolution;
            options["appendixLocation"] = appendixPlace;
            options["withBiography"] = withBiography;
            options["bio"] = textBio;
            options["notesTables"] = notesTables;
            options["endnote"] = endnote;
	    
            var params = prepareXSLParams(options);
            var nouveauXML = prepareImport(xmlField.text, params);
            var nomFichier = xmlField.text.substr(xmlField.text.lastIndexOf(sepChemin) + 1);

            options["noeudAfficher"] = "//text";
            options["appelFonction"] = "importXML";

            var result = importationXML(nouveauXML, File(maquetteField.text), options, nomFichier);
            //sauvegarde
            saveDocument(myDocument, xmlField, maquetteField);

            palette.hide();
            alert(result);
        }
        catch (err) {
            alert(err + " / " + err.line + " / " + err.fileName);
        }

    }

    return palette;
}


function buildBookDialog(){

    var paletteBook = new Window ("palette", i18n('createbook'), undefined, {resizeable: true});
    paletteBook.location = [200, 170];
    paletteBook.alignChildren = "left";
    var main = paletteBook.add ("group");
    main.orientation = "column";
    main.alignChildren = "left";

     //conteneur  
     var conteneurPane = main.add("group");
     conteneurPane.add ("statictext", [0, 10, 200, 30], i18n('bookXMLfile'));
     var conteneurField = conteneurPane.add("edittext", [0, 0, 550, 20], "");
     var conteneurButton = conteneurPane.add ("button", undefined, i18n('dotdotdot'));
    
      //maquette front  
     var maquetteFrontPane = main.add("group");
     maquetteFrontPane.add ("statictext", [0, 10, 200, 30], i18n('bookprelim'));
     var frontField = maquetteFrontPane.add("edittext", [0, 0, 550, 20], "");
     var frontButton = maquetteFrontPane.add ("button", undefined, i18n('dotdotdot'));
     frontButton.onClick= function () 
     {
         frontField.text = File.openDialog(i18n('booktemplate'), (File.fs == "Windows") ?  i18n('booktemplatefilter' ): inddFilter).fsName;
         //pour le mode test
         //backField.text = frontField.text;
         //bodyField.text = frontField.text;
         //intercalField.text = frontField.text;
     }

 
     //---------------panneau d'attribution d'une maquette selon un type; vide tant que le doc XML container n'est pas sélectionné
     var maquettesByTypePanes = new Array();
     var groupTypesPane = main.add("group");
     groupTypesPane.orientation = "column";
     groupTypesPane.alignChildren = "left";
     var groupTypes = new Array();
     conteneurButton.onClick= function () 
     {
         conteneurField.text = File.openDialog(i18n('chooseXMLFile'), (File.fs == "Windows") ?  i18n('XMLFileFilter'): xmlFilter).fsName;
         
         try{
            var conteneurDoc = app.documents.add(false);//on charge le doc sans afficher de fenêtre dans la GUI d'AID
            conteneurDoc.importXML(File(conteneurField.text));
            //on récupère les valeurs d'@type des <group/> parent des <include/>
            var collect= new CollectElementsByXPath("//group[@type]/include");
            __processRuleSet(conteneurDoc.associatedXMLElement, new Array (collect));
            
            for(var idx = 0; idx< collect.values.length; idx++){
                    groupTypes.push(collect.values[idx].parent.xmlAttributes.itemByName("type").value);
            }

            groupTypes = groupTypes.unique();
            for(var i = 0; i < groupTypes.length; i++){
                     var mc = new MaquetteChooser(groupTypes[i], groupTypesPane,inddFilter);
                     maquettesByTypePanes[groupTypes[i]] = mc;
            }
	     paletteBook.layout.layout(true);     	    
	   // **PyB** : ask màj de la boîte de dialogue
// 	    if (dialog.children.length>0) {
// 	    	alert('ici')
//  		for (var z = dialog.children.length-1; z >= 0; z--) {
//  		    dialog.remove(z)
//  		}
// 		}
		
		var options = new Array();
		var params = prepareXSLParams(options);
        preparePalette(conteneurField.text, params)
		
        conteneurDoc.importXML(File(rep_script+"uiPalette.xml"));
	    var collect= new CollectElementsByXPath("//var");
	    __processRuleSet(conteneurDoc.associatedXMLElement, new Array (collect));
	    for(var idx = 0; idx< collect.values.length; idx++){

		if (collect.values[idx].xmlAttributes.itemByName("name").value=="figure")
		{
		    paletteFigures = new figPalette(dialog);
		} else {
			paletteFigures.push("NA")
		}
		
		if (collect.values[idx].xmlAttributes.itemByName("name").value=="table")
		{
		    paletteTable = new tablePalette(dialog,collect.values[idx].xmlAttributes.itemByName("table-head").value,collect.values[idx].xmlAttributes.itemByName("table-note").value,version);

		} else {
		    paletteTable.push("NA");
		}
		
		if (collect.values[idx].xmlAttributes.itemByName("name").value=="author")
		{
		    paletteAuthor = new authorPalette(dialog);
		} else {
		    paletteAuthor.push("NA");
		}

        if (collect.values[idx].xmlAttributes.itemByName("name").value=="dates")
        {
            paletteDates = new datesPalette(dialog);
        } else {
            paletteDates.push("NA");
        }
		
		if (collect.values[idx].xmlAttributes.itemByName("name").value=="abstracts")
		{
		    paletteAbstract = new abstractPalette(dialog);
		} else {
		    paletteAbstract.push("NA");
		}

            if (collect.values[idx].xmlAttributes.itemByName("name").value=="appendix")
        {
            paletteAppendix = new appendixPalette(dialog);
        } else {
            paletteAppendix.push("NA");
        }

        if (collect.values[idx].xmlAttributes.itemByName("name").value=="biography")
        {
            paletteBiography = new biographyPalette(dialog);
        } else {
            paletteBiography.push("NA");
        }
            
        if (collect.values[idx].xmlAttributes.itemByName("name").value=="noteEnd")
		{
		    paletteEndnote = new endnotePalette(dialog,version);		    
		} else {
		    paletteEndnote.push("NA");
		}
		
	    }
            paletteBook.layout.layout(true);
            conteneurDoc.close(SaveOptions.NO)
         }
        catch(e){alert(e);}
     }
    
 
 	var versionPane = main.add("group");
	var versionText = versionPane.add("statictext", undefined, undefined, {name: "versionText"}); 
    versionText.text = "InDesign version : " + version ; 
    
    var paletteFigures = new Array();  
    var paletteTable = new Array();
    var paletteAbstract = new Array();
    var paletteEndnote = new Array();
    var paletteAuthor = new Array();
    var paletteDates = new Array();    
    var paletteAppendix = new Array();  
    var paletteBiography = new Array();  
    var dialog = main.add("group");
    dialog.orientation = "column"; 
    dialog.alignChildren = ["left","top"];

    //buttons
    var buttons = paletteBook.add ("group");
    var applyButton = buttons.add ("button", undefined, i18n('apply'));
    var closeButton = buttons.add ("button", undefined, i18n('close'));
    closeButton.onClick = function () 
    {
        paletteBook.close();
    }

    applyButton.onClick = function () 
    {   
		var resolution;//images resolution
 	    var figuresMode;// = rbFigTab.value;
	    
	    if (paletteFigures[0] == "NA") {
			resolution = "NA";
			figuresMode = "NA";
			figuresVert = "NA";
	    } else {
	    if (paletteFigures[2].rbhr.value == true)
                resolution = "hr";
	    else if (paletteFigures[2].rbbr.value == true) {
                resolution = "br";
	    }
	    else {
                resolution = "mr";
	    }
	    
	    if (paletteFigures[0].figinTable.value == true)
                figuresMode = "tab";
	    else if (paletteFigures[0].figHeap.value == true) {
                figuresMode = "heap";
	    }
	    else {
                figuresMode = "cell";
	    }
	    
	    var figuresVert;
           if (paletteFigures[1].figTitlebelow.value == true)
               figuresVert = "beforeTitle";
           else if (paletteFigures[1].figTitleRight.value == true) {
               figuresVert = "afterTitle";
           }
           else {
               figuresVert = "figTitleUp";
         }
		}
		
        var authorPlace;
	    if (paletteAuthor[0] == "NA") {
		authorPlace = "NA";
	    } else {
		if (paletteAuthor[0].authorbefore.value == true)
                    authorPlace = "beforeTitle";
		else if (paletteAuthor[0].authorafter.value == true) {
                    authorPlace = "afterTitle";
		}
		else {
                    authorPlace = "end";
		}
	    }

        var datesPlace;
        if (paletteDates[0] == "NA") {
        datesPlace = "NA";
        } else {
        if (paletteDates[0].datesFront.value == true)
                    datesPlace = "datesFront";
        else if (paletteDates[0].datesEnd.value == true) {
                    datesPlace = "datesEnd";
        }
        else {
                    datesPlace = "datesNone";
        }
        }

	    var withAbstractAndKeywords
	    var textLang
	    if (paletteAbstract[0] == "NA") {
		withAbstractAndKeywords = "NA";
		textLang = "NA";
	    } else {
		withAbstractAndKeywords = paletteAbstract[0].abstractY.value;
		textLang = paletteAbstract[1].abstractLangP.value;
	    }

        var appendixPlace;
        if (paletteAppendix[0] == "NA") {
        appendixPlace = "NA";
        } else {
        if (paletteAppendix[0].appendixbefore.value == true)
                    appendixPlace = "beforeTitle";
        else if (paletteAppendix[0].appendixafter.value == true) {
                    appendixPlace = "afterTitle";
        }
        else {
                    appendixPlace = "end";
         }
         }

        var withBiography
        var textBio
        if (paletteBiography[0] == "NA") {
        withBiography = "NA";
        textBio = "NA";
        } else {
        withBiography = paletteBiography[0].biographyY.value;
        textBio = paletteBiography[1].biographyPosUE.value;
        }
	    
	    var endnote
	    if (paletteEndnote[0] == "NA") {
			endnote = "NA";
	    } else {
		endnote = paletteEndnote[0].value;
	    }
	    
	    var table
	    if (paletteTable[0] == "NA" || !paletteTable[0].tableTitlePane) {
		table = "NA";
	    } else {
		table = paletteTable[0].tableTitlePane.tableUp.value;
	    }
 
        if(File.fs != "Windows"){
            var iconoPath = (new File(conteneurField.text)).parent.parent.fsName + sepChemin + "icono" + sepChemin + resolution + sepChemin;
            iconoPath = makePlateformFileSystemPath(iconoPath, "\\\\ ");
        }
        else{
            var iconoPath = (new File(conteneurField.text)).parent.parent.fsName + sepChemin + "icono" + sepChemin + resolution + sepChemin;
        }

	    var notesTables;
    	    if (paletteTable[0] == "NA" || !paletteTable[0].tableNotePane || paletteTable[0].tableNotePane.ntindd.value == true)
                notesTables = "footnotes";
		else {
		    notesTables = "notesInTables";
            }
        
        //association @type <=> maquette
        var maquettesAndTypes = new Array();    
        for(var i = 0; i <groupTypes.length; i++){
            type = groupTypes[i];
            maquettePane = maquettesByTypePanes[type];
            maquettesAndTypes[type] = maquettePane.typeField.text;
         }
            
        if(File.fs != "Windows"){
            var iconoPath = (new File(conteneurField.text)).parent.parent.fsName + sepChemin + "icono" + sepChemin + resolution + sepChemin;
            iconoPath = makePlateformFileSystemPath(iconoPath, "\\\\ ");
        }
        else{
            var iconoPath = (new File(conteneurField.text)).parent.parent.fsName + sepChemin + "icono" + sepChemin + resolution + sepChemin;
        }
        
        var options = new Array();
        
 
        options["figuresMode"] = figuresMode;
        options["figuresVert"] = figuresVert;
        options["table"] = table;
        options["authorLocation"] = authorPlace;
        options["datesLocation"] = datesPlace;
        options["withAbstract"] = withAbstractAndKeywords;
        options["lang"] = textLang;
        options["iconoPath"] = iconoPath;  
        options["resolution"] = resolution;
        options["appendixLocation"] = appendixPlace;
        options["withBiography"] = withBiography;
        options["bio"] = textBio;
        options["notesTables"] = notesTables;
        options["endnote"] = endnote;
        
        var params = prepareXSLParams(options);
        //preparePalette(conteneurField.text, params)
        var nouveauXML = prepareImport(conteneurField.text, params);
        var nomFichier = conteneurField.text.substr(conteneurField.text.lastIndexOf(sepChemin) + 1);
        
        makeBook(conteneurField.text, frontField.text, maquettesAndTypes, options);
	paletteBook.close();
    }  
    
    return paletteBook;
}
