/*
 * Decompiled with CFR 0.152.
 */
package poledocpackage.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import poledocpackage.gui.Console;

public class Utils {
    public static void copyFolder(File src, File dest) throws IOException {
        Console.log("copy folder ->" + src.getAbsolutePath() + " / " + dest.getAbsolutePath());
        if (src.isDirectory()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdir();
            }
            for (String file : files = src.list()) {
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                Utils.copyFolder(srcFile, destFile);
            }
        } else {
            Utils.copyFile(src, dest);
        }
    }

    public static void copyFile(File src, File dst) throws IOException {
        int len;
        Console.log("copy file ->" + src.getAbsolutePath() + " / " + dst.getAbsolutePath());
        if (dst.exists()) {
            dst.delete();
        }
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static void delete(Path dst) throws IOException {
        Files.walkFileTree(dst, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

