/*
 * Decompiled with CFR 0.152.
 */
package poledocpackage.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import poledocpackage.PoleDocDeployerToolManager;
import poledocpackage.PoleDocPackage;
import poledocpackage.event.BrowseListener;

public class SoftwarePanel
extends JPanel {
    private JTextField installField;
    private JCheckBox deployCheckBox;
    private JButton browseButton;
    private JButton aboutButton;
    private JLabel installLabel;
    private Dimension FIELD_DIMENSION = new Dimension(250, 25);
    private SoftwarePanel[] dependencies;
    private boolean enabled;
    private String aboutText;
    protected JPanel deployPane;
    protected Box wrapper;
    private JPanel installPane;
    private List<BrowseListener> browseListeners;

    public SoftwarePanel(String label, String software, String action, SoftwarePanel ... dependencies) {
        this(label, software, null, action, dependencies);
    }

    public SoftwarePanel(String label, String software, String about, String action, SoftwarePanel ... dependencies) {
        this.dependencies = dependencies;
        this.aboutText = about;
        this.browseListeners = new ArrayList<BrowseListener>();
        this.wrapper = Box.createVerticalBox();
        this.deployPane = new JPanel(new BorderLayout());
        this.deployCheckBox = new JCheckBox(PoleDocPackage.getInstance().getI18n().getString("deploy") + " " + label);
        this.deployPane.add((Component)this.deployCheckBox, "West");
        this.installPane = new JPanel(new BorderLayout());
        this.installLabel = new JLabel(PoleDocPackage.getInstance().getI18n().getString(software + "_install_location"));
        this.installLabel.setPreferredSize(new Dimension(250, 25));
        this.installField = new JTextField();
        this.installField.setEditable(false);
        this.installField.setPreferredSize(this.FIELD_DIMENSION);
        this.browseButton = new JButton(new ImageIcon(this.getClass().getResource("resources/images/browse.png")));
        this.aboutButton = new JButton(new ImageIcon(this.getClass().getResource("resources/images/about.png")));
        if (PoleDocDeployerToolManager.isOnWindowsSystem()) {
            this.aboutButton.setBorder(null);
            this.aboutButton.setBorderPainted(false);
            this.aboutButton.setContentAreaFilled(false);
        } else {
            this.aboutButton.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        }
        this.browseButton.setToolTipText(PoleDocPackage.getInstance().getI18n().getString("browse"));
        this.aboutButton.setToolTipText(PoleDocPackage.getInstance().getI18n().getString("about"));
        this.installPane.add((Component)this.installLabel, "West");
        this.installPane.add((Component)this.installField, "Center");
        JPanel browseAboutPane = new JPanel();
        browseAboutPane.add(this.browseButton);
        if (this.aboutText != null && !this.aboutText.equals("")) {
            browseAboutPane.add(this.aboutButton);
        }
        this.installPane.add((Component)browseAboutPane, "East");
        this.deployCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ce) {
                SoftwarePanel.this.setInstallEnabled(SoftwarePanel.this.deployCheckBox.isSelected());
                if (SoftwarePanel.this.deployCheckBox.isSelected()) {
                    for (SoftwarePanel sp : SoftwarePanel.this.dependencies) {
                        sp.getCheckBox().setSelected(true);
                        sp.setInstallEnabled(true);
                    }
                }
            }
        });
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFileChooser jfc = new JFileChooser("/");
                jfc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.getAbsolutePath().endsWith(".app") || file.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return PoleDocDeployerToolManager.isOnMacSystem() ? ".app file(s)" : "";
                    }
                });
                jfc.setFileSelectionMode(2);
                boolean checked = false;
                while (!checked) {
                    if (jfc.showOpenDialog(SoftwarePanel.this) == 0) {
                        SoftwarePanel.this.installField.setText(jfc.getSelectedFile().getAbsolutePath());
                        checked = SoftwarePanel.this.checkField();
                        if (!SoftwarePanel.this.checkField()) {
                            JOptionPane.showMessageDialog(SoftwarePanel.this, PoleDocPackage.getInstance().getI18n().getString("bad_field"), PoleDocPackage.getInstance().getI18n().getString("bad_fields_title"), 1);
                        }
                        SoftwarePanel.this.fireFolderChanged();
                        continue;
                    }
                    checked = true;
                }
            }
        });
        this.aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JOptionPane.showMessageDialog(SoftwarePanel.this.aboutButton, SoftwarePanel.this.aboutText, "Infos", 1);
            }
        });
        this.deployCheckBox.setSelected(true);
        this.wrapper.add(this.deployPane);
        this.wrapper.add(this.installPane);
        this.add(this.wrapper);
        this.enabled = true;
        this.installField.setToolTipText(PoleDocPackage.getInstance().getI18n().getString("field_tooltip"));
    }

    public void setInstallEnabled(boolean b) {
        this.installField.setEnabled(b);
        this.browseButton.setEnabled(b);
        this.enabled = b;
    }

    public String getInstallPath() {
        return this.enabled ? this.installField.getText() : null;
    }

    public JCheckBox getCheckBox() {
        return this.deployCheckBox;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setPathPaneVisible(boolean b) {
        this.wrapper.remove(this.installPane);
        this.wrapper.updateUI();
        this.wrapper.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
    }

    public boolean checkField() {
        if (this.getInstallPath() == null) {
            return true;
        }
        if (PoleDocDeployerToolManager.isOnMacSystem()) {
            return !this.getInstallPath().equals("") && this.getInstallPath().endsWith(".app");
        }
        return !this.getInstallPath().equals("");
    }

    public void fireFolderChanged() {
        for (BrowseListener bl : this.browseListeners) {
            bl.folderChanged();
        }
    }

    public void addBrowseListener(BrowseListener al) {
        this.browseListeners.add(al);
    }
}

