/*
 * Decompiled with CFR 0.152.
 */
package poledocpackage.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import poledocpackage.DeployException;
import poledocpackage.PoleDocDeployerTool;
import poledocpackage.PoleDocPackage;
import poledocpackage.event.BrowseListener;
import poledocpackage.event.DeploymentListener;
import poledocpackage.gui.Console;
import poledocpackage.gui.SoftwarePanel;

public class PoleDocPackageGUI
extends JFrame
implements DeploymentListener,
BrowseListener {
    private JPanel configPane;
    private SoftwarePanel inDesignPane;
    private JButton installButton;
    private JButton cancelButton;
    private JToggleButton consoleButton;
    private JScrollPane logScroll;
    private JPanel statePanel;
    private JLabel inDesignDectection;
    private JLabel scriptsInstall;
    private ImageIcon orangeIcon;
    private ImageIcon greenIcon;
    private ImageIcon redIcon;
    private Box aidStatePanel;
    private List<JCheckBox> aidVersionCheckBoxes;
    private JPanel aidVersionsPanel;
    private PoleDocDeployerTool deployer;
    private JPanel stateAndConsolePane;
    public static final String IN_DESIGN_BROWSE_CMD = "AID_BROWSE";
    public static final String XXE_BROWSE_CMD = "XXE_BROWSE";
    public static final String OOFFICE_BROWSE_CMD = "OOFFICE_BROWSE";
    private final String STATE_PANEL = "statepane";
    private final String CONSOLE_PANEL = "consolepane";

    public PoleDocPackageGUI(PoleDocDeployerTool dep) {
        this.deployer = dep;
        JPanel helpPane = new JPanel();
        String help = PoleDocPackage.getInstance().getI18n().getString("packager_help").replace("%PATH%", System.getProperty("user.home") + PoleDocPackage.getInstance().getInstallDirectory() + System.getProperty("file.separator") + "metopes");
        helpPane.add(new JLabel(help));
        this.configPane = new JPanel(new GridLayout(1, 1));
        this.inDesignPane = new SoftwarePanel(PoleDocPackage.getInstance().getI18n().getString("aid_import"), "aid", PoleDocPackage.getInstance().getI18n().getString("aid_about_html"), IN_DESIGN_BROWSE_CMD, new SoftwarePanel[0]);
        this.inDesignPane.addBrowseListener(this);
        JPanel indesignWrap = new JPanel(new BorderLayout());
        indesignWrap.add((Component)this.inDesignPane, "West");
        this.configPane.add(indesignWrap);
        this.orangeIcon = new ImageIcon(this.getClass().getResource("resources/images/orange.png"));
        this.redIcon = new ImageIcon(this.getClass().getResource("resources/images/red.png"));
        this.greenIcon = new ImageIcon(this.getClass().getResource("resources/images/green.png"));
        this.statePanel = new JPanel(new GridLayout(2, 1));
        this.inDesignDectection = new JLabel(PoleDocPackage.getInstance().getI18n().getString("in_design_detection"));
        this.inDesignDectection.setIcon(this.orangeIcon);
        this.scriptsInstall = new JLabel(PoleDocPackage.getInstance().getI18n().getString("scripts_install"));
        this.scriptsInstall.setIcon(this.orangeIcon);
        this.aidStatePanel = Box.createVerticalBox();
        this.aidStatePanel.add(this.inDesignDectection);
        this.aidStatePanel.add(this.scriptsInstall);
        this.aidStatePanel.setBorder(BorderFactory.createTitledBorder(PoleDocPackage.getInstance().getI18n().getString("in_design_deploy_border")));
        this.statePanel.add(this.aidStatePanel);
        this.logScroll = new JScrollPane(Console.gui);
        JPanel buttonsPane = new JPanel();
        this.installButton = new JButton(PoleDocPackage.getInstance().getI18n().getString("install"));
        this.cancelButton = new JButton(PoleDocPackage.getInstance().getI18n().getString("cancel"));
        this.consoleButton = new JToggleButton(PoleDocPackage.getInstance().getI18n().getString("console"));
        buttonsPane.add(this.installButton);
        buttonsPane.add(this.consoleButton);
        buttonsPane.add(this.cancelButton);
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Console.clear();
                            PoleDocPackageGUI.this.deployer.setIndesignInstallPath(PoleDocPackageGUI.this.getInDesignInstallPath());
                            if (!PoleDocPackageGUI.this.checkFields()) {
                                JOptionPane.showMessageDialog(PoleDocPackageGUI.this, PoleDocPackage.getInstance().getI18n().getString("bad_fields"), PoleDocPackage.getInstance().getI18n().getString("bad_fields_title"), 1);
                                return;
                            }
                            PoleDocPackageGUI.this.deployer.deploy();
                            JOptionPane.showMessageDialog(PoleDocPackageGUI.this, PoleDocPackage.getInstance().getI18n().getString("install_completed"), PoleDocPackage.getInstance().getI18n().getString("install_completed_title"), 1);
                            PoleDocPackageGUI.this.revalidate();
                        }
                        catch (DeployException ex) {
                            JOptionPane.showMessageDialog(PoleDocPackageGUI.this, ex.getMessage(), PoleDocPackage.getInstance().getI18n().getString("install_failed"), 0);
                        }
                    }
                });
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                System.exit(0);
            }
        });
        this.stateAndConsolePane = new JPanel(new CardLayout());
        this.stateAndConsolePane.add((Component)this.statePanel, "statepane");
        this.stateAndConsolePane.add((Component)this.logScroll, "consolepane");
        this.consoleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String target = PoleDocPackageGUI.this.consoleButton.isSelected() ? "consolepane" : "statepane";
                CardLayout cl = (CardLayout)PoleDocPackageGUI.this.stateAndConsolePane.getLayout();
                cl.show(PoleDocPackageGUI.this.stateAndConsolePane, target);
            }
        });
        this.consoleButton.setSelected(false);
        Box wrapNorth = Box.createVerticalBox();
        JPanel helpPaneWrapper = new JPanel(new BorderLayout());
        JPanel topWrapper = new JPanel();
        helpPaneWrapper.add((Component)helpPane, "Center");
        helpPaneWrapper.add((Component)new JLabel(new ImageIcon(this.getClass().getResource("resources/images/logopdn.png"))), "West");
        helpPaneWrapper.setBorder(BorderFactory.createTitledBorder(""));
        topWrapper.add(helpPaneWrapper);
        wrapNorth.add(topWrapper);
        wrapNorth.add(this.configPane);
        this.aidVersionCheckBoxes = new ArrayList<JCheckBox>();
        this.aidVersionsPanel = new JPanel();
        wrapNorth.add(this.aidVersionsPanel);
        this.aidVersionsPanel.add(Box.createRigidArea(new Dimension(10, 25)));
        this.getContentPane().add((Component)wrapNorth, "North");
        this.getContentPane().add((Component)this.stateAndConsolePane, "Center");
        this.getContentPane().add((Component)buttonsPane, "South");
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setTitle(PoleDocPackage.getInstance().getI18n().getString("installer_title"));
        this.deployer.addDeploymentListener(this);
    }

    public String getInDesignInstallPath() {
        return this.inDesignPane.getInstallPath();
    }

    public PoleDocPackage.officeSoftware getOfficeSoftware() {
        return PoleDocPackage.officeSoftware.OPEN_OFFICE;
    }

    @Override
    public void inDesignDectectionChanged(final boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PoleDocPackageGUI.this.setLabelFireIcon(PoleDocPackageGUI.this.inDesignDectection, b);
            }
        });
    }

    @Override
    public void scriptsInstallChanged(final boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (b) {
                    PoleDocPackageGUI.this.setLabelFireIcon(PoleDocPackageGUI.this.scriptsInstall, true);
                } else {
                    PoleDocPackageGUI.this.setLabelFireIcon(PoleDocPackageGUI.this.scriptsInstall, false);
                }
            }
        });
    }

    private void setLabelFireIcon(JLabel jl, boolean ok) {
        jl.setIcon(ok ? this.greenIcon : this.redIcon);
        jl.repaint();
    }

    private boolean checkFields() {
        return this.inDesignPane.checkField();
    }

    @Override
    public void folderChanged() {
        try {
            Console.log("R\u00e9pertoire installation InDesign = " + this.inDesignPane.getInstallPath());
            List<File> files = this.deployer.aidPrepare(this.inDesignPane.getInstallPath());
            this.aidVersionsPanel.removeAll();
            this.deployer.clearInDesignVersions();
            Console.log("nombre de version(s) =" + files.size());
            if (files.size() == 1) {
                this.aidVersionsPanel.updateUI();
                this.deployer.addInDesignVersion(files.get(0).getName());
                return;
            }
            String htmlInfo = "<ul>";
            this.aidVersionsPanel.add(Box.createRigidArea(new Dimension(10, 25)));
            this.aidVersionsPanel.add(new JLabel(PoleDocPackage.getInstance().getI18n().getString("aid_scripts_deploy")));
            for (File f : files) {
                htmlInfo = htmlInfo + "<li>" + f.getName() + "</li>";
                JCheckBox cb = new JCheckBox(f.getName());
                this.aidVersionCheckBoxes.add(cb);
                this.aidVersionsPanel.add(cb);
                this.deployer.addInDesignVersion(f.getName());
                cb.setSelected(true);
                cb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        JCheckBox c = (JCheckBox)ae.getSource();
                        if (c.isSelected()) {
                            PoleDocPackageGUI.this.deployer.addInDesignVersion(c.getText());
                        } else {
                            PoleDocPackageGUI.this.deployer.removeInDesignVersion(c.getText());
                        }
                    }
                });
            }
            htmlInfo = htmlInfo + "</ul>";
            htmlInfo = "<html>" + PoleDocPackage.getInstance().getI18n().getString("aid_multi_versions") + htmlInfo + "</html>";
            JOptionPane.showMessageDialog(this, htmlInfo, PoleDocPackage.getInstance().getI18n().getString("aid_multi_versions_info"), 1);
            this.aidVersionsPanel.updateUI();
        }
        catch (DeployException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), PoleDocPackage.getInstance().getI18n().getString("install_failed"), 0);
        }
    }
}

