/*
 * Decompiled with CFR 0.152.
 */
package poledocpackage;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import poledocpackage.DeployException;
import poledocpackage.MacOSXDeployerTool;
import poledocpackage.PoleDocPackage;
import poledocpackage.gui.Console;
import poledocpackage.util.Utils;

public class WindowsDeployerTool
extends MacOSXDeployerTool {
    public static final String USER_WIN_DIRECTORY = System.getProperty("user.home") + SEPARATOR + "AppData" + SEPARATOR + "Roaming" + SEPARATOR;
    public static final String XXE_USER_WIN_DIRECTORY = USER_WIN_DIRECTORY + "XMLmind" + SEPARATOR;
    public static final String WINDOWS_ADDON_FILE = "addon" + SEPARATOR + "tei";
    public static String AID_USER_WIN_DIRECTORY = USER_WIN_DIRECTORY + "Adobe" + SEPARATOR + "InDesign" + SEPARATOR;
    public static final String WIN_OFFICE_USER_PATH = USER_WIN_DIRECTORY + "OpenOffice" + SEPARATOR + "4" + SEPARATOR + "user" + SEPARATOR;

    @Override
    public void deploy() throws DeployException {
        super.deploy();
    }

    @Override
    public void deployOOffice() throws DeployException {
        try {
            File targetDir = PoleDocPackage.getInstance().getOoXSLTargetDir();
            File oldDir = new File(targetDir.getParent() + SEPARATOR + "AEDRES");
            if (oldDir.exists()) {
                for (File f : oldDir.listFiles()) {
                    f.delete();
                }
                boolean b = oldDir.delete();
                Console.log(PoleDocPackage.getInstance().getI18n().getString("log.deleteOldAEDRES"));
            }
            Utils.copyFolder(PoleDocPackage.getInstance().getOoXSLResourcesDir(), PoleDocPackage.getInstance().getOoXSLTargetDir());
            File filterFile = new File(WIN_OFFICE_USER_PATH + "registrymodifications.xcu");
            this.importFilters(filterFile);
            for (File f : PoleDocPackage.getInstance().getOoXSLTargetDir().listFiles()) {
                String name = f.getName();
                if (!name.substring(name.lastIndexOf(".") + 1).equals("xml")) continue;
                f.delete();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Logger.getLogger(WindowsDeployerTool.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void deployInDesign() throws DeployException {
        try {
            File f = new File(AID_USER_WIN_DIRECTORY);
            if (!f.exists()) {
                this.fireInDesignDectectionChanged(false);
                throw new DeployException(PoleDocPackage.getInstance().getI18n().getString("error.badAidDir"));
            }
            this.fireInDesignDectectionChanged(true);
            File scriptPanels = PoleDocPackage.getInstance().getAidScriptPanelsResource();
            for (String s : this.inDesignVersions) {
                for (File local : new File(AID_USER_WIN_DIRECTORY + SEPARATOR + s).listFiles()) {
                    String destDir = AID_USER_WIN_DIRECTORY + s + SEPARATOR + local.getName() + SEPARATOR;
                    Utils.copyFolder(scriptPanels, new File(destDir + "Scripts" + SEPARATOR + "Scripts Panel/" + "metopes"));
                    File old = new File(destDir + "Scripts" + SEPARATOR + "Scripts Panel/" + "aedres");
                    if (!old.exists()) continue;
                    Utils.delete(Paths.get(old.getAbsolutePath(), new String[0]));
                    Console.log(PoleDocPackage.getInstance().getI18n().getString("log.deleteOldAEDRES"));
                }
            }
            this.fireScriptsInstallChanged(true);
        }
        catch (IOException ex) {
            this.fireScriptsInstallChanged(true);
            Logger.getLogger(WindowsDeployerTool.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public List<File> aidPrepare(String path) throws DeployException {
        File[] installs;
        ArrayList<File> l = new ArrayList<File>();
        File rep = new File(AID_USER_WIN_DIRECTORY);
        for (File f : installs = rep.listFiles()) {
            System.out.println(f.getAbsolutePath());
            l.add(f);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean buildAIDConfigLinkFile(String dirLink, String dirTools) {
        OutputStreamWriter fw = null;
        try {
            String targetFile = dirTools + "tools" + SEPARATOR + "tei2indd.xslt";
            System.out.println("flink " + dirLink + SEPARATOR + "lien_xslt.txt");
            File fLink = new File(dirLink + SEPARATOR + "lien_xslt.txt");
            if (!fLink.exists() && !fLink.createNewFile()) {
                boolean bl = false;
                return bl;
            }
            fw = new FileWriter(fLink);
            String content = targetFile;
            fw.write(content);
            Console.log(content);
            fw.flush();
            fw.close();
            fLink.renameTo(fLink);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            Logger.getLogger(WindowsDeployerTool.class.getName()).log(Level.SEVERE, null, ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException ex) {
                Logger.getLogger(MacOSXDeployerTool.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

