/*
 * Decompiled with CFR 0.152.
 */
package poledocpackage;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import poledocpackage.DeployException;
import poledocpackage.PoleDocDeployerToolManager;
import poledocpackage.gui.PoleDocPackageGUI;

public class PoleDocPackage {
    public static final String APP_NAME = "metopes";
    public static final String INSTALL_DIR_PROPERTY_NAME = "install_dir";
    public static final String OLD_XSL_BOOK = "AEDRES/book.xsl";
    public static final String OLD_XSL_UE = "AEDRES/oo_to_tei.xsl";
    public static final String OO_TO_BOOK_XSL = "vol.xsl";
    public static final String OO_TO_TEI_XSL = "ue.xsl";
    private String installDirectory;
    private File ooXSLTargetDir;
    private ResourceBundle i18n;
    private final File ooXSLResourcesDir = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + "resources/open_office/");
    private final File oofficeUEFilterResource = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + "resources/open_office/filter.xml");
    private final File oofficeVolFilterResource = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + "resources/open_office/book_filter.xml");
    private final File aidScriptPanelsResource = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + "resources/in_design_import/metopes");
    private final File aidToolsResources = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + "resources/in_design_import/tools");
    private static PoleDocPackage INSTANCE = null;
    public static String XXE_APPLICATION_NAME;
    public static String OOFFICE_APPLICATION_NAME;
    public static final File XXE_TEI_RESOURCES;

    public static PoleDocPackage getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PoleDocPackage();
        }
        return INSTANCE;
    }

    private PoleDocPackage() {
        try {
            if (PoleDocDeployerToolManager.isOnWindowsSystem()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            try {
                this.i18n = ResourceBundle.getBundle("poledocpackage.i18n", Locale.getDefault());
            }
            catch (Exception e) {
                Locale l = new Locale("FR", "fr");
                this.i18n = ResourceBundle.getBundle("poledocpackage.i18n", l);
            }
            Properties properties = new Properties();
            File configFile = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + PoleDocDeployerToolManager.getConfigurationFile());
            if (!configFile.exists()) {
                JOptionPane.showMessageDialog(null, PoleDocPackage.getInstance().getI18n().getString("error.file") + configFile.getAbsolutePath() + " " + PoleDocPackage.getInstance().getI18n().getString("error.notFound"), "Error", 0);
            }
            properties.load(new FileInputStream(configFile));
            this.installDirectory = properties.getProperty(INSTALL_DIR_PROPERTY_NAME);
            this.ooXSLTargetDir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + this.installDirectory + System.getProperty("file.separator") + APP_NAME);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PoleDocPackage.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(PoleDocPackage.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(PoleDocPackage.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(PoleDocPackage.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(PoleDocPackage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public File getOoXSLResourcesDir() {
        return this.ooXSLResourcesDir;
    }

    public File getOofficeUEFilterResource() {
        return this.oofficeUEFilterResource;
    }

    public File getOofficeVolFilterResource() {
        return this.oofficeVolFilterResource;
    }

    public File getAidScriptPanelsResource() {
        return this.aidScriptPanelsResource;
    }

    public File getAidToolsResources() {
        return this.aidToolsResources;
    }

    public File getOoXSLTargetDir() {
        return this.ooXSLTargetDir;
    }

    public String getInstallDirectory() {
        return this.installDirectory;
    }

    public ResourceBundle getI18n() {
        return this.i18n;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    PoleDocPackageGUI pdpg = new PoleDocPackageGUI(PoleDocDeployerToolManager.buildDeployer());
                    pdpg.setVisible(true);
                    pdpg.pack();
                }
                catch (DeployException ex) {
                    Logger.getLogger(PoleDocPackage.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    static {
        XXE_TEI_RESOURCES = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + "resources/tei");
    }

    public static enum officeSoftware {
        OPEN_OFFICE("Open Office", "OpenOffice"),
        LIBRE_OFFICE("Libre Office", "LibreOffice");

        String name;
        String repository;

        private officeSoftware(String n2, String r) {
            this.name = n2;
            this.repository = r;
        }

        public String toString() {
            return this.name;
        }

        public String getRepository() {
            return this.repository;
        }
    }
}

