/*
 * Decompiled with CFR 0.152.
 */
package poledocpackage;

import poledocpackage.DeployException;
import poledocpackage.MacOSXDeployerTool;
import poledocpackage.PoleDocDeployerTool;
import poledocpackage.WindowsDeployerTool;

public class PoleDocDeployerToolManager {
    public static PoleDocDeployerTool buildDeployer() throws DeployException {
        MacOSXDeployerTool deployer = null;
        if (PoleDocDeployerToolManager.isOnMacSystem()) {
            deployer = new MacOSXDeployerTool();
        } else if (PoleDocDeployerToolManager.isOnWindowsSystem()) {
            deployer = new WindowsDeployerTool();
        }
        return deployer;
    }

    public static boolean isOnMacSystem() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac");
    }

    public static boolean isOnWindowsSystem() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static String getConfigurationFile() {
        return PoleDocDeployerToolManager.isOnMacSystem() ? "configuration.properties" : "configuration_win.properties";
    }
}

