/*
 * Decompiled with CFR 0.152.
 */
package poledocpackage;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import poledocpackage.DeployException;
import poledocpackage.MacOSXDeployerTool;
import poledocpackage.PoleDocPackage;
import poledocpackage.event.DeploymentListener;
import poledocpackage.gui.Console;

public abstract class PoleDocDeployerTool {
    public static final String SEPARATOR = System.getProperty("file.separator");
    public static final String SUPPORTED_OOFFICE_VERSION = "4";
    public static final String OOFFICE_FILTER_FILE = "registrymodifications.xcu";
    private String xxeInstallPath = null;
    private String oofficeInstallPath = null;
    private String indesignInstallPath = null;
    private List<DeploymentListener> deployementListeners = new ArrayList<DeploymentListener>();
    protected List<String> inDesignVersions = new ArrayList<String>();
    private PoleDocPackage.officeSoftware officeSoftware = null;

    public void deploy() throws DeployException {
        if (this.getIndesignInstallPath() != null) {
            this.deployInDesign();
        }
    }

    public void createPDDNFolder() throws DeployException {
        File applicationsFolder = PoleDocPackage.getInstance().getOoXSLTargetDir();
        if (!applicationsFolder.exists() && !applicationsFolder.mkdirs()) {
            throw new DeployException(PoleDocPackage.getInstance().getI18n().getString("error.noMKDIR") + applicationsFolder.getAbsolutePath());
        }
    }

    protected void importFilter(File filterFile, File templateFrag, String xslFile) {
        try {
            DocumentBuilderFactory docbFact = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docbFact.newDocumentBuilder();
            Document fragmentDoc = docBuilder.parse(templateFrag);
            Document mainDoc = docBuilder.parse(filterFile);
            Element items = mainDoc.getDocumentElement();
            Element filterNode = fragmentDoc.getDocumentElement();
            NodeList itList = filterNode.getElementsByTagName("it");
            for (int i = 0; i < itList.getLength(); ++i) {
                Element it = (Element)itList.item(i);
                if (!it.getTextContent().equals("XSL_STYLESHEET")) continue;
                it.setTextContent(xslFile);
            }
            NodeList itemsToAdd = filterNode.getElementsByTagName("item");
            for (int i = 0; i < itemsToAdd.getLength(); ++i) {
                items.appendChild(mainDoc.importNode(itemsToAdd.item(i), true));
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(mainDoc);
            StreamResult streamResult = new StreamResult(new FileOutputStream(filterFile.getAbsolutePath(), false));
            transformer.transform(source, streamResult);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(MacOSXDeployerTool.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SAXException ex) {
            Logger.getLogger(MacOSXDeployerTool.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MacOSXDeployerTool.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (TransformerException ex) {
            Logger.getLogger(MacOSXDeployerTool.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MacOSXDeployerTool.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void importFilters(File filterFile) throws IOException, DeployException {
        if (filterFile.exists()) {
            this.importFilter(filterFile, PoleDocPackage.getInstance().getOofficeUEFilterResource(), System.getProperty("user.home") + (PoleDocPackage.getInstance().getInstallDirectory().startsWith(SEPARATOR) ? "" : SEPARATOR) + PoleDocPackage.getInstance().getInstallDirectory() + SEPARATOR + "metopes" + SEPARATOR + "ue.xsl");
            this.importFilter(filterFile, PoleDocPackage.getInstance().getOofficeVolFilterResource(), System.getProperty("user.home") + SEPARATOR + PoleDocPackage.getInstance().getInstallDirectory() + SEPARATOR + "metopes" + SEPARATOR + "vol.xsl");
            Console.log(PoleDocPackage.getInstance().getI18n().getString("log.filterInstallDone"));
        } else {
            Console.log(PoleDocPackage.getInstance().getI18n().getString("error.noFilter"));
        }
    }

    abstract void deployOOffice() throws DeployException;

    abstract void deployInDesign() throws DeployException;

    public abstract List<File> aidPrepare(String var1) throws DeployException;

    public String getXxeInstallPath() {
        return this.xxeInstallPath;
    }

    public String getOOfficeInstallPath() {
        return this.oofficeInstallPath;
    }

    public String getIndesignInstallPath() {
        return this.indesignInstallPath;
    }

    public void addDeploymentListener(DeploymentListener dl) {
        if (!this.deployementListeners.contains(dl)) {
            this.deployementListeners.add(dl);
        }
    }

    public void removeDeploymebtListener(DeploymentListener dl) {
        this.deployementListeners.remove(dl);
    }

    public void fireInDesignDectectionChanged(boolean b) {
        for (DeploymentListener dl : this.deployementListeners) {
            dl.inDesignDectectionChanged(b);
        }
    }

    public void fireScriptsInstallChanged(boolean b) {
        for (DeploymentListener dl : this.deployementListeners) {
            dl.scriptsInstallChanged(b);
        }
    }

    public PoleDocPackage.officeSoftware getOfficeSoftware() {
        return this.officeSoftware;
    }

    public void addInDesignVersion(String v) {
        if (!this.inDesignVersions.contains(v)) {
            this.inDesignVersions.add(v);
        }
    }

    public void removeInDesignVersion(String v) {
        this.inDesignVersions.remove(v);
    }

    public void setXxeInstallPath(String xxeInstallPath) {
        this.xxeInstallPath = xxeInstallPath;
    }

    public void setOOfficeInstallPath(String oofficeInstallPath) {
        this.oofficeInstallPath = oofficeInstallPath;
    }

    public void setIndesignInstallPath(String indesignInstallPath) {
        this.indesignInstallPath = indesignInstallPath;
    }

    public void setOfficeSoftware(PoleDocPackage.officeSoftware officeSoftware2) {
        this.officeSoftware = officeSoftware2;
    }

    public void clearInDesignVersions() {
        this.inDesignVersions.clear();
    }
}

