/*
 * Decompiled with CFR 0.152.
 */
package poledocpackage;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import poledocpackage.DeployException;
import poledocpackage.PoleDocDeployerTool;
import poledocpackage.PoleDocPackage;
import poledocpackage.gui.Console;
import poledocpackage.util.Utils;

public class MacOSXDeployerTool
extends PoleDocDeployerTool {
    public static final String BUNDLE_SHORT_VERSION_PROPERTY = "CFBundleShortVersionString";
    public static final String BUNDLE_VERSION_PROPERTY = "CFBundleVersion";
    public static final String MAC_XXE_VERSION_FILE = "Contents/Info.plist";
    public static final String MAC_XXE_USER_PATH = System.getProperty("user.home") + "/Library/Application Support/XMLmind/XMLEditor%version%/addon/";
    public static final String MAC_OOFFICE_VERSION_FILE = "Contents/Info.plist";
    public static final String MAC_OFFICE_USER_PATH = System.getProperty("user.home") + "/Library/Application Support/%software%/%version%/user/";
    public static final String IT_TAG = "it";
    public static final String XSL_STRING = "XSL_STYLESHEET";
    public static final String MAC_IN_DESIGN_USER_PATH = System.getProperty("user.home") + "/Library/Preferences/Adobe InDesign/%version%/%locale%/Scripts/";
    public static final String SCRIPTS_PANEL = "Scripts Panel/";
    public static final String XSLT_LINK_FILE = "core/lien_xslt.txt";
    public static final String MAC_IN_DESIGN_USER_INSTALLS = System.getProperty("user.home") + "/Library/Preferences/Adobe InDesign/";
    public static final String TEI_XSL_FILE = "tei2indd.xslt";
    public static final String MAC_IN_DESIGN_VERSION_FILE = "/Contents/Info.plist";
    public static final String LOCALE_SETTING_PROPERTY = "InstallerLocaleSetting";
    private String inDesignLocale;

    @Override
    public void deployOOffice() throws DeployException {
        try {
            Console.log("\n" + PoleDocPackage.getInstance().getI18n().getString("log.deployOOFilter"));
            File targetDir = PoleDocPackage.getInstance().getOoXSLTargetDir();
            File oldDir = new File(targetDir.getParent() + SEPARATOR + "AEDRES");
            if (oldDir.exists()) {
                for (File f : oldDir.listFiles()) {
                    f.delete();
                }
                oldDir.delete();
                Console.log(PoleDocPackage.getInstance().getI18n().getString("log.deleteOldAEDRES"));
            }
            String userOOficeDirectory = MAC_OFFICE_USER_PATH.replaceFirst("%software%", "OpenOffice");
            userOOficeDirectory = userOOficeDirectory.replaceFirst("%version%", "4");
            Utils.copyFolder(PoleDocPackage.getInstance().getOoXSLResourcesDir(), targetDir);
            File filterFile = new File(userOOficeDirectory + "registrymodifications.xcu");
            if (!filterFile.exists()) {
                throw new DeployException(PoleDocPackage.getInstance().getI18n().getString("error.noFilter"));
            }
            Console.log(PoleDocPackage.getInstance().getI18n().getString("log.addFilter") + filterFile.getAbsolutePath());
            if (!this.updateFilters(filterFile.getAbsolutePath())) {
                this.importFilters(filterFile);
            } else {
                Console.log(PoleDocPackage.getInstance().getI18n().getString("log.nameUpdate"));
            }
            for (File f : PoleDocPackage.getInstance().getOoXSLTargetDir().listFiles()) {
                String name = f.getName();
                if (!name.substring(name.lastIndexOf(".") + 1).equals("xml")) continue;
                f.delete();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MacOSXDeployerTool.class.getName()).log(Level.SEVERE, null, ex);
            throw new DeployException(PoleDocPackage.getInstance().getI18n().getString("error.oofficeDeploy"));
        }
        Console.log(PoleDocPackage.getInstance().getI18n().getString("log.deployOODone"));
    }

    @Override
    public void deployInDesign() throws DeployException {
        try {
            Console.log(PoleDocPackage.getInstance().getI18n().getString("log.deployAID"));
            boolean links = true;
            for (String v : this.inDesignVersions) {
                String dir = MAC_IN_DESIGN_USER_PATH.replaceFirst("%version%", v);
                dir = dir.replaceFirst("%locale%", this.inDesignLocale);
                Console.log("\n");
                Console.log(PoleDocPackage.getInstance().getI18n().getString("log.deployInDir") + dir);
                File userDir = new File(dir);
                if (!userDir.exists()) {
                    this.fireInDesignDectectionChanged(false);
                    throw new DeployException(PoleDocPackage.getInstance().getI18n().getString("error.badAidDirVersion") + v);
                }
                this.fireInDesignDectectionChanged(true);
                Console.log(PoleDocPackage.getInstance().getI18n().getString("log.aidCopyScriptAndSaxon"));
                File scriptPanels = PoleDocPackage.getInstance().getAidScriptPanelsResource();
                Utils.copyFolder(scriptPanels, new File(dir + SCRIPTS_PANEL + "metopes"));
                File old = new File(dir + SCRIPTS_PANEL + "aedres");
                if (old.exists()) {
                    Utils.delete(Paths.get(old.getAbsolutePath(), new String[0]));
                    Console.log(PoleDocPackage.getInstance().getI18n().getString("log.deleteOldAEDRES"));
                }
                this.makeAIDXmlRulesLink(dir + SCRIPTS_PANEL + "metopes");
            }
            this.fireScriptsInstallChanged(true);
            Console.log(PoleDocPackage.getInstance().getI18n().getString("log.deployAIDDone"));
        }
        catch (IOException ex) {
            this.fireScriptsInstallChanged(false);
            Logger.getLogger(MacOSXDeployerTool.class.getName()).log(Level.SEVERE, "ola", ex);
        }
    }

    private String findSoftwarePropertyWithDefaultCommand(String fName, String key, int length) {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"defaults", "read", fName, key});
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String value = input.readLine();
            input.close();
            if (length == -1) {
                return value;
            }
            return value.substring(0, length);
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }

    private boolean makeAIDXmlRulesLink(String scriptPanelPath) {
        try {
            String line;
            Console.log(PoleDocPackage.getInstance().getI18n().getString("log.XMLRulesSymLink"));
            String linkName = scriptPanelPath + "/core/XML Rules";
            File fTmp = new File(this.getIndesignInstallPath());
            String target = fTmp.getParentFile().getAbsolutePath() + "/Scripts/XML Rules";
            Process p = Runtime.getRuntime().exec(new String[]{"ln", "-s", target, linkName});
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                System.err.println(line);
                Console.log(line);
            }
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(MacOSXDeployerTool.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Override
    public List<File> aidPrepare(String path) throws DeployException {
        File[] installs;
        ArrayList<File> l = new ArrayList<File>();
        File infoFile = new File(path + "/" + MAC_IN_DESIGN_VERSION_FILE);
        Console.log(PoleDocPackage.getInstance().getI18n().getString("log.aidPList") + infoFile.getAbsolutePath());
        if (!infoFile.exists()) {
            this.fireInDesignDectectionChanged(false);
            throw new DeployException(PoleDocPackage.getInstance().getI18n().getString("error.badAidDir"));
        }
        String plistName = infoFile.getAbsolutePath().replace(".plist", "");
        Console.log(plistName);
        String inDesignVersion = this.findSoftwarePropertyWithDefaultCommand(plistName, BUNDLE_SHORT_VERSION_PROPERTY, 3);
        Console.log(PoleDocPackage.getInstance().getI18n().getString("log.aidDetectedVersion") + inDesignVersion);
        this.inDesignLocale = this.findSoftwarePropertyWithDefaultCommand(plistName, LOCALE_SETTING_PROPERTY, -1);
        if (this.inDesignLocale == null || this.inDesignLocale.equals("")) {
            this.inDesignLocale = Locale.getDefault().toString();
        }
        Console.log("Locale AID: " + this.inDesignLocale);
        File rep = new File(MAC_IN_DESIGN_USER_INSTALLS);
        Console.log("Listing du r\u00e9pertoire " + rep.getAbsolutePath());
        if (!rep.exists()) {
            this.fireInDesignDectectionChanged(false);
            throw new DeployException(PoleDocPackage.getInstance().getI18n().getString("error.badAidDir"));
        }
        for (File f : installs = rep.listFiles()) {
            File fLocal = new File(f.getAbsolutePath() + "/" + this.inDesignLocale);
            if (!fLocal.exists()) {
                Console.log("R\u00e9pertoire non trouv\u00e9 = " + fLocal.getAbsolutePath());
                continue;
            }
            Console.log(PoleDocPackage.getInstance().getI18n().getString("log.newDetectedAID"));
            Console.log("-->" + f.getAbsolutePath());
            l.add(f);
        }
        return l;
    }

    private boolean updateFilters(String filterFile) {
        try {
            Path path = Paths.get(filterFile, new String[0]);
            Charset charset = StandardCharsets.UTF_8;
            String content = new String(Files.readAllBytes(path), charset);
            if (content.contains("AEDRES/book.xsl")) {
                content = content.replaceAll("AEDRES/book.xsl", "metopes" + SEPARATOR + "vol.xsl");
                content = content.replaceAll("AEDRES/oo_to_tei.xsl", "metopes" + SEPARATOR + "ue.xsl");
                Files.write(path, content.getBytes(charset), new OpenOption[0]);
                return true;
            }
        }
        catch (IOException e) {
            Console.log(e.getMessage());
        }
        return false;
    }
}

